/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

public class MemorySamples {
    private Runtime rt;
    private long[] free;
    private long[] total;
    private boolean[] gcPerformed;
    private int n;
    private int everyN;
    private int capacity;
    private int available;
    private int currentIndex;
    private int firstIndex;
    private double averageSumFree;
    private double averageSumTotal;
    private boolean hasNewData;
    private volatile boolean gcPerformedSinceLastSample;

    public MemorySamples(int capacity, int everyN) {
        this.capacity = capacity;
        this.everyN = everyN;
        this.free = new long[capacity];
        this.total = new long[capacity];
        this.gcPerformed = new boolean[capacity];
        this.rt = Runtime.getRuntime();
    }

    public synchronized void sample() {
        this.averageSumFree += (double)this.rt.freeMemory() / (double)this.everyN;
        this.averageSumTotal += (double)this.rt.totalMemory() / (double)this.everyN;
        if (this.n == this.everyN) {
            this.n = 0;
        }
        if (this.n != 0) {
            ++this.n;
            this.hasNewData = false;
            return;
        }
        ++this.n;
        this.free[this.currentIndex] = (long)this.averageSumFree;
        this.total[this.currentIndex] = (long)this.averageSumTotal;
        this.gcPerformed[this.currentIndex] = this.gcPerformedSinceLastSample;
        this.hasNewData = true;
        this.averageSumFree = 0.0;
        this.averageSumTotal = 0.0;
        this.gcPerformedSinceLastSample = false;
        if (this.available < this.capacity) {
            ++this.available;
        } else {
            ++this.firstIndex;
        }
        if (this.firstIndex == this.capacity) {
            this.firstIndex = 0;
        }
        ++this.currentIndex;
        if (this.currentIndex == this.capacity) {
            this.currentIndex = 0;
        }
    }

    public int getAvailable() {
        return this.available;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private int calcArrayIndex(int sampleNumber) {
        int index = sampleNumber + this.firstIndex;
        if (index >= this.capacity) {
            index -= this.capacity;
        }
        return index;
    }

    public long getFree(int sampleNumber) {
        int index = this.calcArrayIndex(sampleNumber);
        return this.free[index];
    }

    public long getTotal(int sampleNumber) {
        int index = this.calcArrayIndex(sampleNumber);
        return this.total[index];
    }

    public long getLastFree() {
        if (this.available == 0) {
            return -1L;
        }
        return this.getFree(this.available - 1);
    }

    public long getLastTotal() {
        if (this.available == 0) {
            return -1L;
        }
        return this.getTotal(this.available - 1);
    }

    public long getLastUsed() {
        if (this.available == 0) {
            return -1L;
        }
        return this.getLastTotal() - this.getLastFree();
    }

    public boolean hasNewData() {
        return this.hasNewData;
    }

    public synchronized void trackGcPerformed() {
        this.gcPerformedSinceLastSample = true;
    }

    public boolean getGcPerformed(int sampleNumber) {
        int index = this.calcArrayIndex(sampleNumber);
        return this.gcPerformed[index];
    }
}

