/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import biz.junginger.freemem.MemorySamples;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class MonitorCanvas
extends Canvas
implements DisposeListener,
PaintListener {
    private MemorySamples samples;
    private Color bg;
    private Color fgFree;
    private Color fgUsed;
    private Color fgTotal;
    private Color fgGrid;
    private Color fgGc;
    private boolean showUsed;
    private boolean showFree;

    public MonitorCanvas(Composite parent, int style, MemorySamples samples) {
        super(parent, style);
        this.samples = samples;
        this.bg = new Color(null, 0, 0, 0);
        this.setBackground(this.bg);
        this.fgFree = new Color(null, 0, 255, 0);
        this.fgUsed = new Color(null, 255, 0, 0);
        this.fgTotal = new Color(null, 0, 0, 255);
        this.fgGrid = new Color(null, 0, 64, 0);
        this.fgGc = new Color(null, 0, 64, 0);
        this.addDisposeListener(this);
        this.addPaintListener(this);
    }

    public void setShowFree(boolean showFree) {
        this.showFree = showFree;
    }

    public void setShowUsed(boolean showUsed) {
        this.showUsed = showUsed;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.bg.dispose();
        this.fgFree.dispose();
        this.fgUsed.dispose();
        this.fgTotal.dispose();
        this.fgGrid.dispose();
        this.fgGc.dispose();
    }

    public void paintControl(PaintEvent e) {
        if (this.samples != null && this.samples.getAvailable() > 0) {
            this.paint(e.gc);
        }
    }

    private void paint(GC gc) {
        int available = this.samples.getAvailable();
        if (available == 0) {
            return;
        }
        int capacity = this.samples.getCapacity();
        Point size = this.getSize();
        int border = 10;
        int dist = 5;
        int offX = border;
        int offY = border;
        long max = this.samples.getLastTotal();
        String totalMemText = this.createMemString(max);
        int textWidth = gc.textExtent((String)totalMemText).x;
        int width = size.x - offX - dist - textWidth - border;
        int height = size.y - offY - border;
        if (height < 10 || width < 10) {
            return;
        }
        this.drawGrid(gc, offX, offY, width, height);
        int textX = offX + width + dist;
        int[] freeCoord = new int[available * 2];
        int[] totalCoord = new int[available * 2];
        int[] usedCoord = new int[available * 2];
        int i = 0;
        while (i < available) {
            int x;
            long free = this.samples.getFree(i);
            long total = this.samples.getTotal(i);
            long used = total - free;
            freeCoord[i * 2] = x = offX + (int)((float)width * (((float)i + 0.5f) / (float)capacity));
            freeCoord[i * 2 + 1] = offY + height - (int)((float)height * ((float)free / (float)max));
            totalCoord[i * 2] = x;
            totalCoord[i * 2 + 1] = offY + height - (int)((float)height * ((float)total / (float)max));
            usedCoord[i * 2] = x;
            usedCoord[i * 2 + 1] = offY + height - (int)((float)height * ((float)used / (float)max));
            if (this.samples.getGcPerformed(i)) {
                gc.setForeground(this.fgGc);
                gc.setLineStyle(3);
                gc.drawLine(x, offY, x, offY + height);
            }
            ++i;
        }
        gc.setLineStyle(1);
        this.drawLineAndText(gc, this.fgTotal, textX, totalCoord, max);
        if (this.showFree) {
            long free = this.samples.getLastUsed();
            this.drawLineAndText(gc, this.fgFree, textX, freeCoord, free);
        }
        if (this.showUsed) {
            long used = this.samples.getLastUsed();
            this.drawLineAndText(gc, this.fgUsed, textX, usedCoord, used);
        }
    }

    private void drawLineAndText(GC gc, Color color, int textX, int[] coords, long memInBytes) {
        gc.setForeground(color);
        gc.drawPolyline(coords);
        int available = this.samples.getAvailable();
        String usedText = this.createMemString(memInBytes);
        int textY = coords[(available - 1) * 2 + 1] - 7;
        gc.drawString(usedText, textX, textY);
    }

    private String createMemString(long memInBytes) {
        return String.valueOf((memInBytes / 1024L * 10L / 1024L + 5L) / 10L) + "M";
    }

    private void drawGrid(GC gc, int offX, int offY, int width, int height) {
        gc.setForeground(this.fgGrid);
        gc.drawRectangle(offX, offY, width, height);
        gc.drawLine(offX, offY + height / 4, offX + width, offY + height / 4);
        gc.drawLine(offX, offY + height / 2, offX + width, offY + height / 2);
        gc.drawLine(offX, offY + height * 3 / 4, offX + width, offY + height * 3 / 4);
    }
}

