/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import biz.junginger.freemem.FreeMemPlugin;
import biz.junginger.freemem.HyperlinkCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button gcFocusCheckbox;
    private Combo imageWidthCombo;
    private static final String infoText = "FreeMem Eclipse Plugin Version 1.30\n(c) 2005 Markus Oliver Junginger. All rights reserved.";
    private static final String linkText = "http://www.junginger.biz/eclipse";
    private Button viewUsedLine;
    private Button viewFreeLine;
    private Button viewAllLines;
    private Combo autoGcDelayCombo;

    protected Control createContents(Composite parent) {
        this.gcFocusCheckbox = new Button(parent, 32);
        this.gcFocusCheckbox.setText("Free memory automatically when window looses focus");
        Label delayLabel = new Label(parent, 0);
        delayLabel.setText("Minimum time span between two automatic GCs in minutes: ");
        this.autoGcDelayCombo = new Combo(parent, 256);
        String[] delayItems = new String[]{"0", "5", "10", "15", "30"};
        this.autoGcDelayCombo.setItems(delayItems);
        new Label(parent, 0);
        Label label = new Label(parent, 0);
        label.setText("Width of memory display in title bar: ");
        this.imageWidthCombo = new Combo(parent, 256);
        String[] s = new String[]{"0", "16", "32", "64", "128", "256"};
        this.imageWidthCombo.setItems(s);
        new Label(parent, 0);
        Label labelVisible = new Label(parent, 0);
        labelVisible.setText("Select the visible items:");
        this.viewUsedLine = new Button(parent, 16);
        this.viewUsedLine.setText("Show only used memory (red)");
        this.viewFreeLine = new Button(parent, 16);
        this.viewFreeLine.setText("Show only free memory (green)");
        this.viewAllLines = new Button(parent, 16);
        this.viewAllLines.setText("Show used and free memory");
        new Label(parent, 0);
        new Label(parent, 0);
        Text info = new Text(parent, 74);
        info.setText(infoText);
        HyperlinkCreator.createHyperlink(parent, linkText);
        this.retrieveValues();
        return new Composite(parent, 0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return FreeMemPlugin.getPlugin().getPreferenceStore();
    }

    protected void performApply() {
        super.performApply();
        this.storeValues();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        boolean focus = store.getDefaultBoolean("PREF_GC_ON_FOCUS_LOSS");
        this.gcFocusCheckbox.setSelection(focus);
        int titleImageWidth = store.getDefaultInt("PREF_VIEW_TITLE_IMAGE_WIDTH");
        this.imageWidthCombo.setText(Integer.toString(titleImageWidth));
        int autoGcDelay = store.getDefaultInt("PREF_AUTO_GC_DELAY");
        this.autoGcDelayCombo.setText(Integer.toString(autoGcDelay));
        boolean used = store.getDefaultBoolean("PREF_VIEW_USED_MEMORY_LINE");
        boolean free = store.getDefaultBoolean("PREF_VIEW_FREE_MEMORY_LINE");
        this.setViewRadioButtons(used, free);
    }

    public boolean performOk() {
        super.performOk();
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("PREF_GC_ON_FOCUS_LOSS", this.gcFocusCheckbox.getSelection());
        int titleImageWidth = store.getDefaultInt("PREF_VIEW_TITLE_IMAGE_WIDTH");
        try {
            String str = this.imageWidthCombo.getText();
            titleImageWidth = Integer.parseInt(str);
        }
        catch (Exception ex) {
            System.out.println("Invalid integer value (PREF_VIEW_TITLE_IMAGE_WIDTH)");
        }
        store.setValue("PREF_VIEW_TITLE_IMAGE_WIDTH", titleImageWidth);
        int autoGcDelay = store.getDefaultInt("PREF_AUTO_GC_DELAY");
        try {
            String str = this.autoGcDelayCombo.getText();
            autoGcDelay = Integer.parseInt(str);
        }
        catch (Exception ex) {
            System.out.println("Invalid integer value (PREF_AUTO_GC_DELAY)");
        }
        store.setValue("PREF_AUTO_GC_DELAY", autoGcDelay);
        boolean used = this.viewUsedLine.getSelection();
        boolean free = this.viewFreeLine.getSelection();
        boolean all = this.viewAllLines.getSelection();
        store.setValue("PREF_VIEW_USED_MEMORY_LINE", used || all);
        store.setValue("PREF_VIEW_FREE_MEMORY_LINE", free || all);
    }

    private void retrieveValues() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean gcFocus = store.getBoolean("PREF_GC_ON_FOCUS_LOSS");
        this.gcFocusCheckbox.setSelection(gcFocus);
        int autoGcDelay = store.getInt("PREF_AUTO_GC_DELAY");
        this.autoGcDelayCombo.setText(Integer.toString(autoGcDelay));
        int titleImageWidth = store.getInt("PREF_VIEW_TITLE_IMAGE_WIDTH");
        this.imageWidthCombo.setText(Integer.toString(titleImageWidth));
        boolean used = store.getBoolean("PREF_VIEW_USED_MEMORY_LINE");
        boolean free = store.getBoolean("PREF_VIEW_FREE_MEMORY_LINE");
        this.setViewRadioButtons(used, free);
    }

    private void setViewRadioButtons(boolean used, boolean free) {
        this.viewAllLines.setSelection(false);
        this.viewUsedLine.setSelection(false);
        this.viewFreeLine.setSelection(false);
        if (used && free) {
            this.viewAllLines.setSelection(true);
        } else if (used) {
            this.viewUsedLine.setSelection(true);
        } else if (free) {
            this.viewFreeLine.setSelection(true);
        }
    }

    public void init(IWorkbench workbench) {
    }
}

