/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import biz.junginger.freemem.FreeMemPlugin;
import biz.junginger.freemem.FreeMemView;
import biz.junginger.freemem.TitleImageData;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ViewTitleUpdater {
    private FreeMemView view;
    private Runtime rt;
    private Image image;
    private Color rectColor = new Color(null, 0, 0, 0);
    private Color gardColor = new Color(null, 0, 0, 0);
    private Color freeGrad1Color = new Color(null, 0, 128, 0);
    private Color freeGrad2Color = new Color(null, 0, 255, 0);
    private Color usedGrad1Color = new Color(null, 128, 0, 0);
    private Color usedGrad2Color = new Color(null, 255, 0, 0);
    private Color totalGrad1Color = new Color(null, 0, 0, 128);
    private Color totalGrad2Color = new Color(null, 0, 0, 255);
    private String currentText;
    private TitleImageData currentTitleImageData;

    public ViewTitleUpdater(FreeMemView view) {
        this.view = view;
        this.rt = Runtime.getRuntime();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
        this.rectColor.dispose();
        this.rectColor = null;
        this.freeGrad1Color.dispose();
        this.freeGrad1Color = null;
        this.freeGrad2Color.dispose();
        this.freeGrad2Color = null;
        this.usedGrad1Color.dispose();
        this.usedGrad1Color = null;
        this.usedGrad2Color.dispose();
        this.usedGrad2Color = null;
        this.totalGrad1Color.dispose();
        this.totalGrad1Color = null;
        this.totalGrad2Color.dispose();
        this.totalGrad2Color = null;
    }

    public void updateUI() {
        if (this.rectColor == null) {
            throw new RuntimeException("Color object unavailable. Already disposed?");
        }
        long free = this.rt.freeMemory() / 1024L;
        long total = this.rt.totalMemory() / 1024L;
        IPreferenceStore prefs = FreeMemPlugin.getPlugin().getPreferenceStore();
        boolean usedFlag = prefs.getBoolean("PREF_VIEW_USED_MEMORY_LINE");
        boolean freeFlag = prefs.getBoolean("PREF_VIEW_FREE_MEMORY_LINE");
        int width = prefs.getInt("PREF_VIEW_TITLE_IMAGE_WIDTH");
        this.checkTitleText(free, total, usedFlag, freeFlag);
        this.checkTitleImage(free, total, usedFlag, freeFlag, width);
    }

    private void checkTitleImage(long free, long total, boolean usedFlag, boolean freeFlag, int width) {
        long used = total - free;
        if (width >= 8) {
            TitleImageData data = new TitleImageData();
            data.setWidth(width);
            this.setDataColors(data, usedFlag, freeFlag);
            int col1Width = freeFlag ? (int)((float)width * (float)free / (float)total) : (int)((float)width * (float)used / (float)total);
            data.setColor1Width(col1Width);
            if (!data.equals(this.currentTitleImageData)) {
                Image newImage = this.createTitleImage(data);
                this.view.setTitleImage(newImage);
                if (this.image != null) {
                    this.image.dispose();
                }
                this.image = newImage;
                this.currentTitleImageData = data;
            }
        } else if (this.image != null) {
            this.view.setTitleImage(null);
            this.image.dispose();
            this.image = null;
        }
    }

    private void setDataColors(TitleImageData data, boolean usedFlag, boolean freeFlag) {
        if (freeFlag) {
            data.setColor1Gradient1(this.freeGrad1Color);
            data.setColor1Gradient2(this.freeGrad2Color);
            if (usedFlag) {
                data.setColor2Gradient1(this.usedGrad1Color);
                data.setColor2Gradient2(this.usedGrad2Color);
            } else {
                data.setColor2Gradient1(this.totalGrad1Color);
                data.setColor2Gradient2(this.totalGrad2Color);
            }
        } else {
            data.setColor1Gradient1(this.usedGrad1Color);
            data.setColor1Gradient2(this.usedGrad2Color);
            data.setColor2Gradient1(this.totalGrad1Color);
            data.setColor2Gradient2(this.totalGrad2Color);
        }
    }

    private Image createTitleImage(TitleImageData data) {
        int height = 16;
        int y = height - 1;
        int width = data.getWidth();
        int color1Width = data.getColor1Width();
        Image newImage = new Image(null, width, height);
        GC gc = new GC((Drawable)newImage);
        gc.setBackground(data.getColor1Gradient1());
        gc.setForeground(data.getColor1Gradient2());
        gc.fillGradientRectangle(0, 0, color1Width, y, true);
        gc.setBackground(data.getColor2Gradient1());
        gc.setForeground(data.getColor2Gradient2());
        gc.fillGradientRectangle(color1Width, 0, width - color1Width, y, true);
        gc.setForeground(this.rectColor);
        gc.drawRectangle(0, 0, color1Width, y);
        gc.drawRectangle(0, 0, width - 1, y);
        gc.dispose();
        return newImage;
    }

    private void checkTitleText(long free, long total, boolean usedFlag, boolean freeFlag) {
        String text = this.createMemoryText(free, total, freeFlag, usedFlag);
        if (text != null && !text.equals(this.currentText)) {
            this.view.setTitleV2AndV3(text);
            this.currentText = text;
        }
    }

    private String createMemoryText(long free, long total, boolean freeFlag, boolean usedFlag) {
        String text;
        long freeM10 = free * 10L / 1024L;
        long totalM10 = total * 10L / 1024L;
        long usedM10 = totalM10 - freeM10;
        if (freeFlag && usedFlag) {
            text = "Used: " + usedM10 / 10L + "." + usedM10 % 10L + " M  ";
            text = String.valueOf(text) + "Free: " + freeM10 / 10L + "." + freeM10 % 10L + " M  ";
            text = String.valueOf(text) + "Total: " + totalM10 / 10L + "." + totalM10 % 10L + " M";
        } else if (freeFlag) {
            text = String.valueOf(freeM10 / 10L) + "." + freeM10 % 10L + " of ";
            text = String.valueOf(text) + totalM10 / 10L + "." + totalM10 % 10L + " M free";
        } else if (usedFlag) {
            text = String.valueOf(usedM10 / 10L) + "." + usedM10 % 10L + " of ";
            text = String.valueOf(text) + totalM10 / 10L + "." + totalM10 % 10L + " M used";
        } else {
            text = "Neither free nor used memory selected";
        }
        return text;
    }
}

