/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geom.util.RobustLineIntersector;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.IntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import com.vividsolutions.jts.noding.snapround.MCIndexPointSnapper;
import java.util.Collection;
import java.util.List;

public class MCIndexSnapRounder
implements Noder {
    private final LineIntersector li = new RobustLineIntersector();
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection nodedSegStrings;

    public MCIndexSnapRounder(PrecisionModel pm) {
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    public Collection<SegmentString> getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings((Collection)this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.noder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(this.noder.getMonotoneChains(), (STRtree)this.noder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List<Coordinate> intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List<Coordinate> findInteriorIntersections(Collection<SegmentString> segStrings, LineIntersector li2) {
        IntersectionFinderAdder intFinderAdder = new IntersectionFinderAdder(li2);
        this.noder.setSegmentIntersector((SegmentIntersector)intFinderAdder);
        this.noder.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection<Coordinate> snapPts) {
        for (Coordinate snapPt : snapPts) {
            this.pointSnapper.snap(new HotPixel(snapPt, this.scaleFactor, this.li));
        }
    }

    public void computeVertexSnaps(Collection<NodedSegmentString> edges) {
        for (NodedSegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(NodedSegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        for (int i = 0; i < pts0.length - 1; ++i) {
            HotPixel hotPixel = new HotPixel(pts0[i], this.scaleFactor, this.li);
            boolean isNodeAdded = this.pointSnapper.snap(hotPixel, (SegmentString)e, i);
            if (!isNodeAdded) continue;
            e.addIntersection(pts0[i], i);
        }
    }
}

