/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geom.util.RobustLineIntersector;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeList;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.operation.buffer.OffsetCurveSetBuilder;
import com.vividsolutions.jts.operation.buffer.SubgraphDepthLocater;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BufferBuilder {
    private BufferParameters bufParams;
    private PrecisionModel workingPrecisionModel;
    private Noder workingNoder;
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();

    private static int depthDelta(Label label) {
        int lLoc = label.getLocation(0, 1);
        int rLoc = label.getLocation(0, 2);
        if (lLoc == 0 && rLoc == 2) {
            return 1;
        }
        if (lLoc == 2 && rLoc == 0) {
            return -1;
        }
        return 0;
    }

    public BufferBuilder(BufferParameters bufParams) {
        this.bufParams = bufParams;
    }

    public void setWorkingPrecisionModel(PrecisionModel pm) {
        this.workingPrecisionModel = pm;
    }

    public void setNoder(Noder noder) {
        this.workingNoder = noder;
    }

    public Geometry buffer(Geometry g, double distance) {
        PrecisionModel precisionModel = this.workingPrecisionModel;
        if (precisionModel == null) {
            precisionModel = g.getPrecisionModel();
        }
        this.geomFact = g.getFactory();
        OffsetCurveBuilder curveBuilder = new OffsetCurveBuilder(precisionModel, this.bufParams);
        OffsetCurveSetBuilder curveSetBuilder = new OffsetCurveSetBuilder(g, distance, curveBuilder);
        List bufferSegStrList = curveSetBuilder.getCurves();
        if (bufferSegStrList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        this.computeNodedEdges(bufferSegStrList, precisionModel);
        this.graph = new PlanarGraph((NodeFactory)new OverlayNodeFactory());
        this.graph.addEdges(this.edgeList.getEdges());
        List subgraphList = this.createSubgraphs(this.graph);
        PolygonBuilder polyBuilder = new PolygonBuilder(this.geomFact);
        this.buildSubgraphs(subgraphList, polyBuilder);
        List resultPolyList = polyBuilder.getPolygons();
        if (resultPolyList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        Geometry resultGeom = this.geomFact.buildGeometry((Collection)resultPolyList);
        return resultGeom;
    }

    private Noder getNoder(PrecisionModel precisionModel) {
        if (this.workingNoder != null) {
            return this.workingNoder;
        }
        MCIndexNoder noder = new MCIndexNoder();
        RobustLineIntersector li = new RobustLineIntersector();
        li.setPrecisionModel(precisionModel);
        noder.setSegmentIntersector((SegmentIntersector)new IntersectionAdder((LineIntersector)li));
        return noder;
    }

    private void computeNodedEdges(List bufferSegStrList, PrecisionModel precisionModel) {
        Noder noder = this.getNoder(precisionModel);
        noder.computeNodes((Collection)bufferSegStrList);
        Collection nodedSegStrings = noder.getNodedSubstrings();
        for (SegmentString segStr : nodedSegStrings) {
            Label oldLabel = (Label)segStr.getData();
            Edge edge = new Edge(segStr.getCoordinates(), new Label(oldLabel));
            this.insertUniqueEdge(edge);
        }
    }

    protected void insertUniqueEdge(Edge e) {
        Edge existingEdge = this.edgeList.findEqualEdge(e);
        if (existingEdge != null) {
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                labelToMerge = new Label(e.getLabel());
                labelToMerge.flip();
            }
            existingLabel.merge(labelToMerge);
            int mergeDelta = BufferBuilder.depthDelta(labelToMerge);
            int existingDelta = existingEdge.getDepthDelta();
            int newDelta = existingDelta + mergeDelta;
            existingEdge.setDepthDelta(newDelta);
        } else {
            this.edgeList.add(e);
            e.setDepthDelta(BufferBuilder.depthDelta(e.getLabel()));
        }
    }

    private List createSubgraphs(PlanarGraph graph) {
        ArrayList<BufferSubgraph> subgraphList = new ArrayList<BufferSubgraph>();
        for (Node node : graph.getNodes()) {
            if (node.isVisited()) continue;
            BufferSubgraph subgraph = new BufferSubgraph();
            subgraph.create(node);
            subgraphList.add(subgraph);
        }
        Collections.sort(subgraphList, Collections.reverseOrder());
        return subgraphList;
    }

    private void buildSubgraphs(List subgraphList, PolygonBuilder polyBuilder) {
        ArrayList<BufferSubgraph> processedGraphs = new ArrayList<BufferSubgraph>();
        for (BufferSubgraph subgraph : subgraphList) {
            Coordinate p = subgraph.getRightmostCoordinate();
            SubgraphDepthLocater locater = new SubgraphDepthLocater(processedGraphs);
            int outsideDepth = locater.getDepth(p);
            subgraph.computeDepth(outsideDepth);
            subgraph.findResultEdges();
            processedGraphs.add(subgraph);
            polyBuilder.add((Collection)subgraph.getDirectedEdges(), (Collection)subgraph.getNodes());
        }
    }

    private static Geometry convertSegStrings(Iterator it) {
        GeometryFactory fact = new GeometryFactory();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        while (it.hasNext()) {
            SegmentString ss = (SegmentString)it.next();
            LineString line = fact.createLineString(ss.getCoordinates());
            lines.add(line);
        }
        return fact.buildGeometry(lines);
    }

    private Geometry createEmptyResultGeometry() {
        Polygon emptyGeom = this.geomFact.createPolygon(null, null);
        return emptyGeom;
    }
}

