/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.buffer.BufferOp;

public class Coalescence {
    public static double get(LineString ls, double lineSymbolWidthM) {
        double symbolArea = BufferOp.bufferOp((Geometry)ls, lineSymbolWidthM * 0.5, 5, 2).getArea();
        double straightSymbolArea = lineSymbolWidthM * ls.getLength();
        double coal = (straightSymbolArea - symbolArea) / straightSymbolArea;
        if (coal < 0.0) {
            return 0.0;
        }
        return coal;
    }

    public static double get(LineString ls, double lineSymbolWidthMM, double scale) {
        return Coalescence.get(ls, lineSymbolWidthMM * scale * 0.001);
    }
}

