/*
 * Decompiled with CFR 0.152.
 */
package SGImplify;

import Tuple.Tuple2f;
import Tuple.Tuple3f;
import java.util.Vector;

public class SGImplify {
    public static Tuple2f[] simplifyLine2D(float tol, Tuple2f[] V) {
        int i;
        int n = V.length;
        float tol2 = tol * tol;
        Tuple2f[] vt = new Tuple2f[n];
        int[] mk = new int[n];
        Vector<Tuple2f> sV = new Vector<Tuple2f>();
        for (int b = 0; b < n; ++b) {
            mk[b] = 0;
        }
        vt[0] = V[0];
        int k = 1;
        int pv = 0;
        for (i = 1; i < n; ++i) {
            if (V[i].distanceSquared(V[pv]) < tol2) continue;
            vt[k++] = V[i];
            pv = i;
        }
        if (pv < n - 1) {
            vt[k++] = V[n - 1];
        }
        mk[k - 1] = 1;
        mk[0] = 1;
        SGImplify.simplifyDP2D(tol, vt, 0, k - 1, mk);
        int m = 0;
        for (i = 0; i < k; ++i) {
            if (mk[i] != 1) continue;
            sV.add(vt[i]);
        }
        Object[] out = new Tuple2f[sV.size()];
        sV.copyInto(out);
        return out;
    }

    private static void simplifyDP2D(float tol, Tuple2f[] v, int j, int k, int[] mk) {
        if (k <= j + 1) {
            return;
        }
        int maxi = j;
        float maxd2 = 0.0f;
        float tol2 = tol * tol;
        Tuple2f u = v[k].minus(v[j]);
        float cu = u.dot(u);
        for (int i = j + 1; i < k; ++i) {
            float dv2;
            Tuple2f w = v[i].minus(v[j]);
            float cw = w.dot(u);
            if (cw <= 0.0f) {
                dv2 = v[i].distanceSquared(v[j]);
            } else if (cu <= cw) {
                dv2 = v[i].distanceSquared(v[k]);
            } else {
                float b = cw / cu;
                Tuple2f Pb = v[j].minus(u.times(-b));
                dv2 = v[i].distanceSquared(Pb);
            }
            if (dv2 <= maxd2) continue;
            maxi = i;
            maxd2 = dv2;
        }
        if (maxd2 > tol2) {
            mk[maxi] = 1;
            SGImplify.simplifyDP2D(tol, v, j, maxi, mk);
            SGImplify.simplifyDP2D(tol, v, maxi, k, mk);
        }
    }

    public static Tuple3f[] simplifyLine3D(float tol, Tuple3f[] V) {
        int i;
        int n = V.length;
        float tol2 = tol * tol;
        Tuple3f[] vt = new Tuple3f[n];
        int[] mk = new int[n];
        Vector<Tuple3f> sV = new Vector<Tuple3f>();
        for (int b = 0; b < n; ++b) {
            mk[b] = 0;
        }
        vt[0] = V[0];
        int k = 1;
        int pv = 0;
        for (i = 1; i < n; ++i) {
            if (V[i].distanceSquared(V[pv]) < tol2) continue;
            vt[k++] = V[i];
            pv = i;
        }
        if (pv < n - 1) {
            vt[k++] = V[n - 1];
        }
        mk[k - 1] = 1;
        mk[0] = 1;
        SGImplify.simplifyDP3D(tol, vt, 0, k - 1, mk);
        int m = 0;
        for (i = 0; i < k; ++i) {
            if (mk[i] != 1) continue;
            sV.add(vt[i]);
        }
        Object[] out = new Tuple3f[sV.size()];
        sV.copyInto(out);
        return out;
    }

    private static void simplifyDP3D(float tol, Tuple3f[] v, int j, int k, int[] mk) {
        if (k <= j + 1) {
            return;
        }
        int maxi = j;
        float maxd2 = 0.0f;
        float tol2 = tol * tol;
        Tuple3f u = v[k].minus(v[j]);
        float cu = u.dot(u);
        for (int i = j + 1; i < k; ++i) {
            float dv2;
            Tuple3f w = v[i].minus(v[j]);
            float cw = w.dot(u);
            if (cw <= 0.0f) {
                dv2 = v[i].distanceSquared(v[j]);
            } else if (cu <= cw) {
                dv2 = v[i].distanceSquared(v[k]);
            } else {
                float b = cw / cu;
                Tuple3f Pb = v[j].minus(u.times(-b));
                dv2 = v[i].distanceSquared(Pb);
            }
            if (dv2 <= maxd2) continue;
            maxi = i;
            maxd2 = dv2;
        }
        if (maxd2 > tol2) {
            mk[maxi] = 1;
            SGImplify.simplifyDP3D(tol, v, j, maxi, mk);
            SGImplify.simplifyDP3D(tol, v, maxi, k, mk);
        }
    }
}

