/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.overlay.snap.GeometryTransformer;
import com.vividsolutions.jts.simplify.TaggedLineString;
import com.vividsolutions.jts.simplify.TaggedLinesSimplifier;
import java.util.HashMap;
import java.util.Map;

public class TopologyPreservingSimplifier {
    private Geometry inputGeom;
    private TaggedLinesSimplifier lineSimplifier = new TaggedLinesSimplifier();
    Map<Geometry, TaggedLineString> linestringMap;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        TopologyPreservingSimplifier tss = new TopologyPreservingSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public TopologyPreservingSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.lineSimplifier.setDistanceTolerance(distanceTolerance);
    }

    public Geometry getResultGeometry() {
        this.linestringMap = new HashMap<Geometry, TaggedLineString>();
        this.inputGeom.apply((GeometryComponentFilter)new LineStringMapBuilderFilter());
        this.lineSimplifier.simplify(this.linestringMap.values());
        Geometry result = new LineStringTransformer().transform(this.inputGeom);
        return result;
    }

    class LineStringMapBuilderFilter
    implements GeometryComponentFilter {
        LineStringMapBuilderFilter() {
        }

        public void filter(Geometry geom) {
            if (geom instanceof LinearRing) {
                TaggedLineString taggedLine = new TaggedLineString((LineString)geom, 4);
                TopologyPreservingSimplifier.this.linestringMap.put(geom, taggedLine);
            } else if (geom instanceof LineString) {
                TaggedLineString taggedLine = new TaggedLineString((LineString)geom, 2);
                TopologyPreservingSimplifier.this.linestringMap.put(geom, taggedLine);
            }
        }
    }

    class LineStringTransformer
    extends GeometryTransformer {
        LineStringTransformer() {
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            if (parent instanceof LineString) {
                TaggedLineString taggedLine = TopologyPreservingSimplifier.this.linestringMap.get(parent);
                return this.createCoordinateSequence(taggedLine.getResultCoordinates());
            }
            return super.transformCoordinates(coords, parent);
        }
    }
}

