/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.util.logging.Logger;

public class DouglasPeuckerRamerFilter {
    static Logger logger = Logger.getLogger(DouglasPeuckerRamerFilter.class.getName());

    public static Geometry get(Geometry g, double d) {
        if (d < 0.0) {
            logger.warning("Distance tolerance must be positive: " + d);
            return (Geometry)g.clone();
        }
        if (d == 0.0) {
            return (Geometry)g.clone();
        }
        Geometry g_ = DouglasPeuckerSimplifier.simplify(g, d);
        if (g_ != null && !g_.isEmpty() && IsValidOp.isValid((Geometry)g_) && g_.getGeometryType() == g.getGeometryType()) {
            return g_;
        }
        g_ = TopologyPreservingSimplifier.simplify(g, d);
        if (g_ == null) {
            logger.warning("Null geometry");
            return g;
        }
        if (g_.getGeometryType() != g.getGeometryType()) {
            logger.warning("Different types of geometry");
            return g;
        }
        if (!IsValidOp.isValid((Geometry)g_)) {
            logger.warning("Non valid geometry");
            return g;
        }
        if (g_.isEmpty()) {
            logger.warning("Empty geometry");
            return g;
        }
        return g_;
    }
}

