/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.Rotation;
import org.opencarto.algo.Stretching;

public class Cusmoo {
    private static Logger logger = Logger.getLogger(Cusmoo.class.getName());
    private static final double sqpi = Math.sqrt(Math.PI);

    public static LineString get(LineString line, double symbolWidthMM, double scale) {
        return Cusmoo.get(line, symbolWidthMM, scale, true);
    }

    public static LineString get(LineString line, double symbolWidthMM, double scale, boolean post) {
        if (line.isClosed()) {
            logger.warning("Closed line not supported.");
            return line;
        }
        return line.getFactory().createLineString(Cusmoo.get(line.getCoordinates(), symbolWidthMM, scale, post));
    }

    public static Coordinate[] get(Coordinate[] coords, double symbolWidthMM, double scale) {
        return Cusmoo.get(coords, symbolWidthMM, scale, true);
    }

    public static Coordinate[] get(Coordinate[] coords, double symbolWidthMM, double scale, boolean post) {
        double a2;
        if (coords.length <= 2) {
            return coords;
        }
        double res = 0.1 * scale * 0.001;
        double[] s = new double[coords.length];
        s[0] = 0.0;
        double s_ = 0.0;
        for (int k = 1; k < coords.length; ++k) {
            s[k] = s_ += coords[k - 1].distance(coords[k]);
        }
        double length = s[coords.length - 1];
        double[] orientation = new double[coords.length - 1];
        for (int k = 0; k < coords.length - 1; ++k) {
            orientation[k] = Math.atan2(coords[k + 1].y - coords[k].y, coords[k + 1].x - coords[k].x);
        }
        double[] alpha = new double[coords.length - 1];
        alpha[0] = orientation[0];
        for (int k = 1; k < coords.length - 1; ++k) {
            double deviation = orientation[k] - orientation[k - 1];
            if (deviation > Math.PI) {
                deviation -= Math.PI * 2;
            }
            if (deviation < -Math.PI) {
                deviation += Math.PI * 2;
            }
            alpha[k] = deviation;
        }
        int m = (int)(length / res);
        Coordinate[] out = new Coordinate[m];
        double sigma = symbolWidthMM * scale * 0.001;
        out[0] = coords[0];
        Coordinate c2 = coords[0];
        double a = 0.0;
        for (int i = 1; i < m; ++i) {
            Coordinate c1;
            double smoothedAlpha = Cusmoo.smoothedAlpha(s, alpha, i - 1, sigma, res);
            a += smoothedAlpha;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "angle=" + a * 180.0 / Math.PI);
            }
            out[i] = c1 = new Coordinate(c2.x + res * Math.cos(a), c2.y + res * Math.sin(a));
            c2 = c1;
        }
        LineString ls = new GeometryFactory().createLineString(out);
        out = DouglasPeuckerSimplifier.simplify((Geometry)ls, (double)res).getCoordinates();
        ls = null;
        if (!post) {
            return out;
        }
        double a1 = Math.atan2(coords[coords.length - 1].y - coords[0].y, coords[coords.length - 1].x - coords[0].x);
        a = a1 - (a2 = Math.atan2(out[out.length - 1].y - out[0].y, out[out.length - 1].x - out[0].x));
        if (a > Math.PI) {
            a -= Math.PI * 2;
        }
        if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        out = Rotation.get((Coordinate[])out, (Coordinate)coords[0], (double)a);
        double k = coords[coords.length - 1].distance(coords[0]) / out[out.length - 1].distance(out[0]);
        return Stretching.get((Coordinate[])out, (Coordinate)coords[0], (double)(a1 - 1.5707963267948966), (double)k);
    }

    private static double smoothedAlpha(double[] s, double[] alpha, int i, double sig, double res) {
        if (i == 0) {
            return alpha[0];
        }
        double out = 0.0;
        double sigma3 = 3.0 * sig;
        for (int k = 1; k < alpha.length; ++k) {
            double x = res * ((double)i - 0.5) - s[k];
            if (Math.abs(x) > sigma3) continue;
            out += alpha[k] * Math.exp(-Math.pow(x / sig, 2.0));
        }
        return res * out / (sig * sqpi);
    }
}

