/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.lifecycle.Scheduling;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchedules {
    List<Scheduling> schedules;

    public DefaultSchedules() {
    }

    public DefaultSchedules(List<Scheduling> schedules) {
        this.schedules = schedules;
    }

    public List<ExecutionPlanItem> createExecutionPlanItem(MavenProject mavenProject, List<MojoExecution> executions) {
        BuilderCommon.attachToThread((MavenProject)mavenProject);
        ArrayList<ExecutionPlanItem> result = new ArrayList<ExecutionPlanItem>();
        for (MojoExecution mojoExecution : executions) {
            String lifeCyclePhase = mojoExecution.getLifecyclePhase();
            Scheduling scheduling = this.getScheduling("default");
            Schedule schedule = null;
            if (scheduling != null && (schedule = scheduling.getSchedule(mojoExecution)) == null) {
                schedule = scheduling.getSchedule(lifeCyclePhase);
            }
            result.add(new ExecutionPlanItem(mojoExecution, schedule));
        }
        return result;
    }

    Scheduling getScheduling(String lifecyclePhaseName) {
        for (Scheduling schedule : this.schedules) {
            if (!lifecyclePhaseName.equals(schedule.getLifecycle())) continue;
            return schedule;
        }
        return null;
    }

    public List<Scheduling> getSchedules() {
        return this.schedules;
    }
}

