/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDepenciesDialog
extends TitleAreaDialog
implements IMenuListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateDepenciesDialog.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private CheckboxTreeViewer codebaseViewer;
    private Collection<IProject> projects;
    private Button offlineModeBtn;
    private Button forceUpdateBtn;
    private List<String> projectPaths;
    private final IProject[] initialSelection;
    private IProject[] selectedProjects;
    private boolean offlineMode;
    private boolean forceUpdate;
    private final Action selectTree = new Action(Messages.UpdateDepenciesDialog_selectTree){

        public void run() {
            UpdateDepenciesDialog.this.codebaseViewer.setSubtreeChecked((Object)UpdateDepenciesDialog.this.getSelection(), true);
        }
    };
    private final Action deselectTree = new Action(Messages.UpdateDepenciesDialog_deselectTree){

        public void run() {
            UpdateDepenciesDialog.this.codebaseViewer.setSubtreeChecked((Object)UpdateDepenciesDialog.this.getSelection(), false);
        }
    };

    public UpdateDepenciesDialog(Shell parentShell, IProject[] initialSelection) {
        super(parentShell);
        this.initialSelection = initialSelection;
        this.offlineMode = MavenPlugin.getMavenConfiguration().isOffline();
        this.forceUpdate = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.UpdateDepenciesDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label lblAvailable = new Label(container, 0);
        lblAvailable.setText(Messages.UpdateDepenciesDialog_availableCodebasesLabel);
        lblAvailable.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.codebaseViewer = new CheckboxTreeViewer(container, 2048);
        this.codebaseViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object element) {
                if (element instanceof Collection) {
                    return ((Collection)element).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IProject) {
                    String elePath = String.valueOf(new File(((IProject)parentElement).getLocationURI()).toString()) + SEPARATOR;
                    String prevPath = null;
                    ArrayList<IProject> children = new ArrayList<IProject>();
                    for (String path : UpdateDepenciesDialog.this.projectPaths) {
                        if (path.length() == elePath.length() || !path.startsWith(elePath) || prevPath != null && path.startsWith(prevPath)) continue;
                        prevPath = path;
                        children.add(UpdateDepenciesDialog.this.getProject(path));
                    }
                    return children.toArray();
                }
                if (parentElement instanceof Collection) {
                    return ((Collection)parentElement).toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                String elePath = String.valueOf(new File(((IProject)element).getLocationURI()).toString()) + SEPARATOR;
                String prevPath = null;
                for (String path : UpdateDepenciesDialog.this.projectPaths) {
                    if (elePath.length() == path.length() || !elePath.startsWith(path) || prevPath != null && prevPath.length() >= path.length()) continue;
                    prevPath = path;
                }
                return prevPath == null ? UpdateDepenciesDialog.this.projects : UpdateDepenciesDialog.this.getProject(prevPath);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IProject) {
                    String elePath = String.valueOf(new File(((IProject)element).getLocationURI()).toString()) + SEPARATOR;
                    for (String path : UpdateDepenciesDialog.this.projectPaths) {
                        if (elePath.length() == path.length() || !path.startsWith(elePath)) continue;
                        return true;
                    }
                } else if (element instanceof Collection) {
                    return !((Collection)element).isEmpty();
                }
                return false;
            }
        });
        this.codebaseViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return MavenImages.createOverlayImage("project-mlabel.gif", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"), MavenImages.MAVEN_OVERLAY, 0);
            }

            public String getText(Object element) {
                return element instanceof IProject ? ((IProject)element).getName() : "";
            }
        });
        this.projects = this.getMavenCodebases();
        this.codebaseViewer.setInput(this.projects);
        this.codebaseViewer.expandAll();
        IProject[] iProjectArray = this.initialSelection;
        int n = this.initialSelection.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.codebaseViewer.setSubtreeChecked((Object)project, true);
            ++n2;
        }
        if (this.initialSelection.length > 0) {
            this.codebaseViewer.reveal((Object)this.initialSelection[0]);
        }
        Tree tree = this.codebaseViewer.getTree();
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.heightHint = 300;
        gd.widthHint = 300;
        tree.setLayoutData((Object)gd);
        Button selectAllBtn = new Button(container, 0);
        selectAllBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        selectAllBtn.setText(Messages.UpdateDepenciesDialog_selectAll);
        selectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : UpdateDepenciesDialog.this.projects) {
                    UpdateDepenciesDialog.this.codebaseViewer.setSubtreeChecked((Object)project, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllBtn = new Button(container, 0);
        deselectAllBtn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        deselectAllBtn.setText(Messages.UpdateDepenciesDialog_deselectAll);
        deselectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : UpdateDepenciesDialog.this.projects) {
                    UpdateDepenciesDialog.this.codebaseViewer.setSubtreeChecked((Object)project, false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button expandAllBtn = new Button(container, 0);
        expandAllBtn.setLayoutData((Object)new GridData(4, 1024, false, true, 1, 1));
        expandAllBtn.setText(Messages.UpdateDepenciesDialog_expandAll);
        expandAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDepenciesDialog.this.codebaseViewer.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button collapseAllBtn = new Button(container, 0);
        collapseAllBtn.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        collapseAllBtn.setText(Messages.UpdateDepenciesDialog_collapseAll);
        collapseAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDepenciesDialog.this.codebaseViewer.collapseAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.offlineModeBtn = new Button(container, 32);
        this.offlineModeBtn.setText(Messages.UpdateDepenciesDialog_offline);
        this.offlineModeBtn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.offlineModeBtn.setSelection(this.offlineMode);
        this.forceUpdateBtn = new Button(container, 32);
        this.forceUpdateBtn.setText(Messages.UpdateDepenciesDialog_forceUpdate);
        this.forceUpdateBtn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.forceUpdateBtn.setSelection(this.forceUpdate);
        this.setTitle(Messages.UpdateDepenciesDialog_title);
        this.setMessage(Messages.UpdateDepenciesDialog_dialogMessage);
        this.createMenu();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        Object[] obj = this.codebaseViewer.getCheckedElements();
        IProject[] projects = new IProject[obj.length];
        int i = 0;
        while (i < obj.length) {
            projects[i] = (IProject)obj[i];
            ++i;
        }
        this.selectedProjects = projects;
        this.offlineMode = this.offlineModeBtn.getSelection();
        this.forceUpdate = this.forceUpdateBtn.getSelection();
        super.okPressed();
    }

    private Collection<IProject> getMavenCodebases() {
        this.projectPaths = new LinkedList<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                URI locationURI;
                if (project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && (locationURI = project.getLocationURI()) != null) {
                    this.projectPaths.add(String.valueOf(new File(locationURI).toString()) + SEPARATOR);
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            ++n2;
        }
        Collections.sort(this.projectPaths);
        if (this.projectPaths.isEmpty()) {
            return Collections.emptyList();
        }
        this.projects = new ArrayList<IProject>();
        String previous = this.projectPaths.get(0);
        UpdateDepenciesDialog.addProject(this.projects, previous);
        for (String path : this.projectPaths) {
            if (path.startsWith(previous)) continue;
            previous = path;
            this.projects.add(this.getProject(path));
        }
        return this.projects;
    }

    private static void addProject(Collection<IProject> projects, String location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] iContainerArray = root.findContainersForLocationURI(new File(location).toURI());
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container instanceof IProject) {
                projects.add((IProject)container);
                break;
            }
            ++n2;
        }
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    public boolean isOffline() {
        return this.offlineMode;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    private IProject getProject(String path) {
        IContainer[] containers;
        IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(path).toURI());
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container instanceof IProject) {
                return (IProject)container;
            }
            ++n2;
        }
        return null;
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu contextMenu = menuMgr.createContextMenu(this.codebaseViewer.getControl());
        menuMgr.addMenuListener((IMenuListener)this);
        this.codebaseViewer.getControl().setMenu(contextMenu);
        menuMgr.setRemoveAllWhenShown(true);
    }

    private IProject getSelection() {
        ISelection selection = this.codebaseViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IProject)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.codebaseViewer.getSelection().isEmpty()) {
            return;
        }
        if (this.codebaseViewer.getSelection() instanceof IStructuredSelection) {
            manager.add((IAction)this.selectTree);
            manager.add((IAction)this.deselectTree);
        }
    }
}

