/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;

public class MapBasedTagGroup
implements TagGroup {
    private final Map<String, String> tagMap;

    public MapBasedTagGroup(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.tagMap = map;
    }

    public MapBasedTagGroup(Iterable<Tag> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException();
        }
        this.tagMap = new HashMap<String, String>();
        for (Tag tag : iterable) {
            if (tag == null) {
                throw new IllegalArgumentException();
            }
            this.tagMap.put(tag.key, tag.value);
        }
    }

    public MapBasedTagGroup(Tag ... tagArray) {
        this.tagMap = new HashMap<String, String>(tagArray.length);
        for (Tag tag : tagArray) {
            if (tag == null) {
                throw new IllegalArgumentException();
            }
            this.tagMap.put(tag.key, tag.value);
        }
    }

    @Override
    public String getValue(String string) {
        assert (string != null);
        return this.tagMap.get(string);
    }

    @Override
    public boolean containsKey(String string) {
        assert (string != null);
        return this.tagMap.containsKey(string);
    }

    @Override
    public boolean containsValue(String string) {
        assert (string != null);
        return this.tagMap.containsValue(string);
    }

    @Override
    public boolean contains(Tag tag) {
        assert (tag != null);
        return tag.value.equals(this.tagMap.get(tag.key));
    }

    @Override
    public boolean contains(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        return string2.equals(this.tagMap.get(string));
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tagMap.isEmpty();
    }

    @Override
    public Iterator<Tag> iterator() {
        LinkedList<Tag> linkedList = new LinkedList<Tag>();
        for (String string : this.tagMap.keySet()) {
            linkedList.add(new Tag(string, this.tagMap.get(string)));
        }
        return Collections.unmodifiableCollection(linkedList).iterator();
    }

    public String toString() {
        return this.tagMap.toString();
    }
}

