/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.data.osmosis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSourceObserver;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlReader;

public class OSMFileDataSource
implements DataSource<OwnNode, OwnWay, OwnRelation, OwnMember> {
    private static final boolean useDebugLabels = true;
    private boolean complete = false;
    private Map<Long, Node> nodesById = new HashMap<Long, Node>();
    private Map<Long, Way> waysById = new HashMap<Long, Way>();
    private Map<Long, Relation> relationsById = new HashMap<Long, Relation>();
    private Collection<OwnNode> ownNodes;
    private Collection<OwnWay> ownWays;
    private Collection<OwnRelation> ownRelations;
    private final Sink sinkImplementation = new Sink(){

        @Override
        public void release() {
        }

        @Override
        public void complete() {
            OSMFileDataSource.this.setCompleteTrue();
        }

        @Override
        public void process(EntityContainer entityContainer) {
            Entity entity = entityContainer.getEntity();
            if (entity instanceof Node) {
                OSMFileDataSource.this.nodesById.put(entity.getId(), (Node)entity);
            } else if (entity instanceof Way) {
                OSMFileDataSource.this.waysById.put(entity.getId(), (Way)entity);
            } else if (entity instanceof Relation) {
                OSMFileDataSource.this.relationsById.put(entity.getId(), (Relation)entity);
            }
        }
    };

    private synchronized boolean isComplete() {
        return this.complete;
    }

    private synchronized void setCompleteTrue() {
        this.complete = true;
    }

    public OSMFileDataSource(File file) throws IOException {
        XmlReader xmlReader = new XmlReader(file, false, CompressionMethod.None);
        xmlReader.setSink(this.sinkImplementation);
        Thread thread = new Thread(xmlReader);
        thread.start();
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isComplete()) {
            throw new IOException("couldn't read from file");
        }
        this.convertToOwnRepresentation();
    }

    private void convertToOwnRepresentation() {
        Object object;
        WayNode wayNode;
        Object object2;
        this.ownNodes = new ArrayList<OwnNode>(this.nodesById.size());
        this.ownWays = new ArrayList<OwnWay>(this.waysById.size());
        this.ownRelations = new ArrayList<OwnRelation>(this.relationsById.size());
        HashMap<Node, Object> hashMap = new HashMap<Node, Object>();
        HashMap<Way, OwnWay> hashMap2 = new HashMap<Way, OwnWay>();
        HashMap<Relation, Object> hashMap3 = new HashMap<Relation, Object>();
        for (Node entity : this.nodesById.values()) {
            object2 = new OwnNode(entity.getLatitude(), entity.getLongitude(), this.tagGroupForEntity(entity));
            this.ownNodes.add((OwnNode)object2);
            hashMap.put(entity, object2);
        }
        for (Way way : this.waysById.values()) {
            object2 = way.getWayNodes();
            ArrayList<OwnNode> arrayList = new ArrayList<OwnNode>(object2.size());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                wayNode = (WayNode)iterator.next();
                object = this.nodesById.get(wayNode.getNodeId());
                arrayList.add((OwnNode)hashMap.get(object));
            }
            OwnWay ownWay = new OwnWay(this.tagGroupForEntity(way), arrayList);
            this.ownWays.add(ownWay);
            hashMap2.put(way, ownWay);
        }
        for (Relation relation : this.relationsById.values()) {
            object2 = new OwnRelation(this.tagGroupForEntity(relation), relation.getMembers().size());
            this.ownRelations.add((OwnRelation)object2);
            hashMap3.put(relation, object2);
        }
        for (Relation relation : hashMap3.keySet()) {
            object2 = (OwnRelation)hashMap3.get(relation);
            for (RelationMember relationMember : relation.getMembers()) {
                wayNode = null;
                if (relationMember.getMemberType() == EntityType.Node) {
                    wayNode = hashMap.get(this.nodesById.get(relationMember.getMemberId()));
                } else if (relationMember.getMemberType() == EntityType.Way) {
                    wayNode = hashMap2.get(this.waysById.get(relationMember.getMemberId()));
                } else {
                    if (relationMember.getMemberType() != EntityType.Relation) continue;
                    wayNode = hashMap3.get(this.relationsById.get(relationMember.getMemberId()));
                }
                object = new OwnMember(relationMember.getMemberRole(), wayNode);
                ((OwnRelation)object2).relationMembers.add(object);
            }
        }
        this.nodesById = null;
        this.waysById = null;
        this.relationsById = null;
    }

    private TagGroup tagGroupForEntity(Entity entity) {
        HashMap<String, String> hashMap = new HashMap<String, String>(entity.getTags().size());
        for (Tag tag : entity.getTags()) {
            hashMap.put(tag.getKey(), tag.getValue());
        }
        return new MapBasedTagGroup(hashMap);
    }

    @Override
    public void addObserver(DataSourceObserver dataSourceObserver) {
    }

    @Override
    public void deleteObserver(DataSourceObserver dataSourceObserver) {
    }

    @Override
    public double getLat(OwnNode ownNode) {
        return ownNode.lat;
    }

    @Override
    public double getLon(OwnNode ownNode) {
        return ownNode.lon;
    }

    @Override
    public List<OwnMember> getMembers(OwnRelation ownRelation) {
        return ownRelation.relationMembers;
    }

    @Override
    public Collection<OwnNode> getNodes() {
        return this.ownNodes;
    }

    @Override
    public Collection<OwnWay> getWays() {
        return this.ownWays;
    }

    @Override
    public Collection<OwnRelation> getRelations() {
        return this.ownRelations;
    }

    @Override
    public List<OwnNode> getNodes(OwnWay ownWay) {
        return ownWay.nodes;
    }

    @Override
    public TagGroup getTagsN(OwnNode ownNode) {
        return ownNode.tags;
    }

    @Override
    public TagGroup getTagsR(OwnRelation ownRelation) {
        return ownRelation.tags;
    }

    @Override
    public TagGroup getTagsW(OwnWay ownWay) {
        return ownWay.tags;
    }

    @Override
    public Object getMember(OwnMember ownMember) {
        return ownMember.member;
    }

    @Override
    public String getRole(OwnMember ownMember) {
        return ownMember.role;
    }

    @Override
    public boolean isNMember(OwnMember ownMember) {
        return ownMember.member instanceof OwnNode;
    }

    @Override
    public boolean isWMember(OwnMember ownMember) {
        return ownMember.member instanceof OwnWay;
    }

    @Override
    public boolean isRMember(OwnMember ownMember) {
        return ownMember.member instanceof OwnRelation;
    }

    public static class OwnMember {
        private final String role;
        private final Object member;

        public OwnMember(String string, Object object) {
            this.role = string;
            this.member = object;
        }
    }

    public class OwnRelation {
        private final TagGroup tags;
        private final List<OwnMember> relationMembers;

        public OwnRelation(TagGroup tagGroup, int n) {
            this.tags = tagGroup;
            this.relationMembers = new ArrayList<OwnMember>(n);
        }
    }

    public class OwnWay {
        private final TagGroup tags;
        private final List<OwnNode> nodes;

        public OwnWay(TagGroup tagGroup, List<OwnNode> list) {
            this.tags = tagGroup;
            this.nodes = list;
        }

        public String toString() {
            if (this.tags.containsKey("debug:label")) {
                return this.tags.getValue("debug:label");
            }
            return this.nodes.get(0) + "->[" + (this.nodes.size() - 2) + "]->" + this.nodes.get(this.nodes.size() - 1);
        }
    }

    public class OwnNode {
        private final double lat;
        private final double lon;
        private final TagGroup tags;

        public OwnNode(double d, double d2, TagGroup tagGroup) {
            this.lat = d;
            this.lon = d2;
            this.tags = tagGroup;
        }

        public String toString() {
            if (this.tags.containsKey("debug:label")) {
                return this.tags.getValue("debug:label");
            }
            return "(" + this.lat + ", " + this.lon + ", " + this.tags + ")";
        }
    }
}

