/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValueStringParser {
    private static final Pattern DEC_POINT_PATTERN = Pattern.compile("^(\\-?\\d+)\\.(\\d+)$");
    private static final Pattern KMH_PATTERN = Pattern.compile("^(\\d+)\\s*km/h$");
    private static final Pattern MPH_PATTERN = Pattern.compile("^(\\d+)\\s*mph$");
    private static final float KM_PER_MILE = 1.609344f;
    private static final Pattern M_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*m$");
    private static final Pattern KM_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*km$");
    private static final Pattern MI_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*mi$");
    private static final Pattern FEET_INCHES_PATTERN = Pattern.compile("^([\\d]+)'\\s*([\\d]+)\"");
    private static final double M_PER_MI = 1609.344;
    private static final double M_PER_INCH = (double)0.0254f;
    private static final Pattern T_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*t$");
    private static final Pattern INCLINE_PATTERN = Pattern.compile("^(\\-?\\d+(?:\\.\\d+)?)\\s*%$");

    private ValueStringParser() {
    }

    public static final Float parseOsmDecimal(String string, boolean bl) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 || bl) {
                return Float.valueOf(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Matcher matcher = DEC_POINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2.length() > 0 || string3.length() > 0) {
                try {
                    boolean bl2 = string2.startsWith("-");
                    float f = Integer.parseInt(string2);
                    float f2 = Integer.parseInt(string3);
                    double d = (double)Math.abs(f) + Math.pow(10.0, -string3.length()) * (double)f2;
                    if (bl2) {
                        d = -d;
                    }
                    if (d >= 0.0 || bl) {
                        return Float.valueOf((float)d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static final Float parseSpeed(String string) {
        Object object;
        Float f = ValueStringParser.parseOsmDecimal(string, false);
        if (f != null) {
            return f;
        }
        Matcher matcher = KMH_PATTERN.matcher(string);
        if (matcher.matches()) {
            object = matcher.group(1);
            try {
                return Float.valueOf(Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (((Matcher)(object = MPH_PATTERN.matcher(string))).matches()) {
            String string2 = ((Matcher)object).group(1);
            try {
                int n = Integer.parseInt(string2);
                return Float.valueOf(1.609344f * (float)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Float parseMeasure(String string) {
        Float f = ValueStringParser.parseOsmDecimal(string, false);
        if (f != null) {
            return f;
        }
        Matcher matcher = M_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return ValueStringParser.parseOsmDecimal(string2, false);
        }
        Matcher matcher2 = KM_PATTERN.matcher(string);
        if (matcher2.matches()) {
            String string3 = matcher2.group(1);
            float f2 = ValueStringParser.parseOsmDecimal(string3, false).floatValue();
            return Float.valueOf(1000.0f * f2);
        }
        Matcher matcher3 = MI_PATTERN.matcher(string);
        if (matcher3.matches()) {
            String string4 = matcher3.group(1);
            float f3 = ValueStringParser.parseOsmDecimal(string4, false).floatValue();
            return Float.valueOf((float)(1609.344 * (double)f3));
        }
        Matcher matcher4 = FEET_INCHES_PATTERN.matcher(string);
        if (matcher4.matches()) {
            String string5 = matcher4.group(1);
            String string6 = matcher4.group(2);
            try {
                int n = Integer.parseInt(string5);
                int n2 = Integer.parseInt(string6);
                if (n >= 0 && n2 >= 0 && n2 < 12) {
                    return Float.valueOf((float)((double)0.0254f * (double)(12 * n + n2)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Float parseWeight(String string) {
        Float f = ValueStringParser.parseOsmDecimal(string, false);
        if (f != null) {
            return f;
        }
        Matcher matcher = T_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return ValueStringParser.parseOsmDecimal(string2, false);
        }
        return null;
    }

    public static final Float parseIncline(String string) {
        Matcher matcher = INCLINE_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return ValueStringParser.parseOsmDecimal(string2, true);
        }
        return null;
    }

    public static final Float parseAngle(String string) {
        Float f = ValueStringParser.parseOsmDecimal(string, false);
        if (f != null) {
            return Float.valueOf(f.floatValue() % 360.0f);
        }
        if ("N".equals(string)) {
            return Float.valueOf(0.0f);
        }
        if ("NNE".equals(string)) {
            return Float.valueOf(22.5f);
        }
        if ("NE".equals(string)) {
            return Float.valueOf(45.0f);
        }
        if ("ENE".equals(string)) {
            return Float.valueOf(67.5f);
        }
        if ("E".equals(string)) {
            return Float.valueOf(90.0f);
        }
        if ("ESE".equals(string)) {
            return Float.valueOf(112.5f);
        }
        if ("SE".equals(string)) {
            return Float.valueOf(135.0f);
        }
        if ("SSE".equals(string)) {
            return Float.valueOf(157.5f);
        }
        if ("S".equals(string)) {
            return Float.valueOf(180.0f);
        }
        if ("SSW".equals(string)) {
            return Float.valueOf(202.5f);
        }
        if ("SW".equals(string)) {
            return Float.valueOf(225.0f);
        }
        if ("WSW".equals(string)) {
            return Float.valueOf(247.5f);
        }
        if ("W".equals(string)) {
            return Float.valueOf(270.0f);
        }
        if ("WNW".equals(string)) {
            return Float.valueOf(292.5f);
        }
        if ("NW".equals(string)) {
            return Float.valueOf(315.0f);
        }
        if ("NNW".equals(string)) {
            return Float.valueOf(337.5f);
        }
        return null;
    }
}

