/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.io.File;
import java.util.List;
import org.osm2world.console.LatLonEle;
import org.osm2world.console.Resolution;
import org.osm2world.core.target.common.rendering.OrthoTilesUtil;
import org.osm2world.core.target.common.rendering.TileNumber;
import uk.co.flamingpenguin.jewel.cli.Option;

public interface CLIArguments {
    public static final String OUTPUT_PATTERN = "(.*)\\.(?:obj|pov|png)";

    @Option(description="the .osm input file", shortName={"i"})
    public File getInput();

    public boolean isInput();

    @Option(description="output files", shortName={"o"}, pattern="(.*)\\.(?:obj|pov|png)")
    public List<File> getOutput();

    public boolean isOutput();

    @Option(description="properties file with configuration parameters")
    public File getConfig();

    public boolean isConfig();

    @Option(description="output size in pixels", pattern="([0-9]{1,9}),([0-9]{1,9})", defaultValue={"800,600"})
    public Resolution getResolution();

    public boolean isResolution();

    @Option(description="downwards angle of orthographic view in degrees", longName="oview.angle", defaultValue={"30"})
    public double getOviewAngle();

    public boolean isOviewAngle();

    @Option(description="direction from which the orthographic view is rendered", pattern="[NESW]", longName="oview.from", defaultValue={"S"})
    public OrthoTilesUtil.CardinalDirection getOviewFrom();

    public boolean isOviewFrom();

    @Option(description="lat,lon pairs defining a bounding box for orthographic view", pattern="([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?)", longName="oview.bbox")
    public List<LatLonEle> getOviewBoundingBox();

    public boolean isOviewBoundingBox();

    @Option(description="zoom,x,y triples of tiles defining a bounding box for orthographic view", pattern="([0-9]{1,2}),([0-9]{1,9}),([0-9]{1,9})", longName="oview.tiles")
    public List<TileNumber> getOviewTiles();

    public boolean isOviewTiles();

    @Option(description="lat,lon,ele of camera position for perspective view", pattern="([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?)", longName="pview.pos")
    public LatLonEle getPviewPos();

    public boolean isPviewPos();

    @Option(description="lat,lon,ele of camera look-at for perspective view", pattern="([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?)", longName="pview.lookAt")
    public LatLonEle getPviewLookat();

    public boolean isPviewLookat();

    @Option(description="vertical field of view angle for perspective view, in degrees", longName="pview.fovy", defaultValue={"45"})
    public double getPviewFovy();

    public boolean isPviewFovy();

    @Option(description="aspect ratio (width / height) for perspective view", longName="pview.aspect")
    public double getPviewAspect();

    public boolean isPviewAspect();

    @Option(description="writes execution times to the command line")
    public boolean getPerformancePrint();

    @Option(description="appends a line with execution times to a file")
    public File getPerformanceTable();

    public boolean isPerformanceTable();

    @Option(description="start the graphical user interface")
    public boolean getGui();

    @Option(helpRequest=true, description="show this help", shortName={"?"})
    public boolean getHelp();

    @Option(description="print software version and exit")
    public boolean getVersion();

    @Option(description="a file containing one set of parameters per line")
    public File getParameterFile();

    public boolean isParameterFile();
}

