/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.osm2world.console.CLIArguments;
import org.osm2world.console.CLIArgumentsUtil;

public class CLIArgumentsGroup {
    private final CLIArguments representative;
    private final List<CLIArguments> cliArgumentsList;

    public CLIArgumentsGroup(CLIArguments cLIArguments) {
        Preconditions.checkNotNull(cLIArguments);
        this.representative = cLIArguments;
        this.cliArgumentsList = new ArrayList<CLIArguments>();
        this.cliArgumentsList.add(cLIArguments);
    }

    public void addCLIArguments(CLIArguments cLIArguments) {
        Preconditions.checkNotNull(cLIArguments);
        Preconditions.checkArgument(this.isCompatible(cLIArguments), "argument incompatible with group");
        this.cliArgumentsList.add(cLIArguments);
    }

    public CLIArguments getRepresentative() {
        return this.representative;
    }

    public List<CLIArguments> getCLIArgumentsList() {
        return this.cliArgumentsList;
    }

    public boolean isCompatible(CLIArguments cLIArguments) {
        return CLIArgumentsGroup.isCompatible(this.representative, cLIArguments);
    }

    private static final boolean isCompatible(CLIArguments cLIArguments, CLIArguments cLIArguments2) {
        return CLIArgumentsUtil.getProgramMode(cLIArguments) == CLIArgumentsUtil.ProgramMode.CONVERT && CLIArgumentsUtil.getProgramMode(cLIArguments2) == CLIArgumentsUtil.ProgramMode.CONVERT && cLIArguments.getInput().equals(cLIArguments2.getInput()) && (cLIArguments.isConfig() && cLIArguments.getConfig().equals(cLIArguments2.getConfig()) || !cLIArguments.isConfig() && !cLIArguments2.isConfig());
    }
}

