/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osm2world.console.CLIArguments;

public final class CLIArgumentsUtil {
    private CLIArgumentsUtil() {
    }

    public static final boolean isValid(CLIArguments cLIArguments) {
        return CLIArgumentsUtil.getErrorString(cLIArguments) == null;
    }

    public static final String getErrorString(CLIArguments cLIArguments) {
        if (CLIArgumentsUtil.getProgramMode(cLIArguments) == ProgramMode.CONVERT) {
            if (!cLIArguments.isInput() || !cLIArguments.isOutput()) {
                return "input and output are required arguments for a conversion";
            }
            if (cLIArguments.isOviewTiles() && cLIArguments.getOviewTiles().isEmpty()) {
                return "at least one tile required";
            }
            if (cLIArguments.isOviewBoundingBox() && cLIArguments.getOviewBoundingBox().size() < 2) {
                return "bounding box requires at least two lat,lon pairs";
            }
            if (cLIArguments.isOviewTiles() && cLIArguments.isOviewBoundingBox()) {
                return "define *either* tiles or bounding box for orthographic view";
            }
            for (File file : cLIArguments.getOutput()) {
                if (CLIArgumentsUtil.getOutputMode(file) != null) continue;
                return "cannot identify file type from name " + file + "\navailable output types: " + OutputMode.values();
            }
            if (cLIArguments.isPviewPos() && !cLIArguments.isPviewLookat() || cLIArguments.isPviewLookat() && !cLIArguments.isPviewPos()) {
                return "camera position and look-at for perspective view cannot be used separately, both must be defined";
            }
            if (CLIArgumentsUtil.hasOrthographicArg(cLIArguments) && CLIArgumentsUtil.hasPerspectiveArg(cLIArguments)) {
                return "you cannot combine arguments for perspective view and orthographic view";
            }
        }
        return null;
    }

    private static final boolean hasOrthographicArg(CLIArguments cLIArguments) {
        return cLIArguments.isOviewBoundingBox() || cLIArguments.isOviewTiles();
    }

    private static final boolean hasPerspectiveArg(CLIArguments cLIArguments) {
        return cLIArguments.isPviewLookat() || cLIArguments.isPviewPos();
    }

    public static final ProgramMode getProgramMode(CLIArguments cLIArguments) {
        return cLIArguments.isParameterFile() ? ProgramMode.PARAMFILE : (cLIArguments.getHelp() ? ProgramMode.HELP : (cLIArguments.getVersion() ? ProgramMode.VERSION : (cLIArguments.getGui() ? ProgramMode.GUI : ProgramMode.CONVERT)));
    }

    public static final OutputMode getOutputMode(File file) {
        if (file.getName().toLowerCase().endsWith(".obj")) {
            return OutputMode.OBJ;
        }
        if (file.getName().toLowerCase().endsWith(".pov")) {
            return OutputMode.POV;
        }
        if (file.getName().toLowerCase().endsWith(".png")) {
            return OutputMode.PNG;
        }
        return null;
    }

    public static final List<String[]> getUnparsedParameterGroups(File file) throws IOException {
        String string;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    arrayList2.add(matcher.group(1));
                    continue;
                }
                if (matcher.group(2) != null) {
                    arrayList2.add(matcher.group(2));
                    continue;
                }
                arrayList2.add(matcher.group());
            }
            arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
        }
        return arrayList;
    }

    public static enum OutputMode {
        OBJ,
        POV,
        PNG;

    }

    public static enum ProgramMode {
        GUI,
        CONVERT,
        HELP,
        VERSION,
        PARAMFILE;

    }
}

