/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import com.sun.opengl.util.Screenshot;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.primitivebuffer.JOGLPrimitiveBufferRenderer;
import org.osm2world.core.target.primitivebuffer.PrimitiveBuffer;

public final class ImageExport {
    private static final int CANVAS_LIMIT = 1024;
    private static final String BG_COLOR_CONFIG_KEY = "backgroundColor";

    private ImageExport() {
    }

    public static void writeImageFile(Configuration configuration, File file, int n, int n2, ConversionFacade.Results results, Camera camera, Projection projection) throws IOException {
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            throw new Error("Cannot create GLPbuffer for OpenGL output!");
        }
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        if (configuration.containsKey(BG_COLOR_CONFIG_KEY)) {
            try {
                Color.decode(configuration.getString(BG_COLOR_CONFIG_KEY)).getColorComponents(fArray);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("incorrect color value: " + configuration.getString(BG_COLOR_CONFIG_KEY));
            }
        }
        PrimitiveBuffer primitiveBuffer = new PrimitiveBuffer();
        TargetUtil.renderWorldObjects(primitiveBuffer, results.getMapData());
        TargetUtil.renderObject(primitiveBuffer, results.getTerrain());
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int n3 = 1 + (n - 1) / 1024;
        int n4 = 1 + (n2 - 1) / 1024;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = i * 1024;
                int n6 = i + 1 < n3 ? n5 + 1023 : n - 1;
                int n7 = n6 - n5 + 1;
                int n8 = j * 1024;
                int n9 = j + 1 < n4 ? n8 + 1023 : n2 - 1;
                int n10 = n9 - n8 + 1;
                GLCapabilities gLCapabilities = new GLCapabilities();
                gLCapabilities.setDoubleBuffered(false);
                GLPbuffer gLPbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, n7, n10, null);
                GL gL = gLPbuffer.getGL();
                gLPbuffer.getContext().makeCurrent();
                gL.glFrontFace(2305);
                gL.glClearColor(fArray[0], fArray[1], fArray[2], 1.0f);
                gL.glEnable(2929);
                gL.glCullFace(1029);
                gL.glEnable(2884);
                gL.glClear(16640);
                JOGLTarget.setProjectionMatricesForPart(gL, projection, (double)n5 / (double)(n - 1), (double)n6 / (double)(n - 1), (double)n8 / (double)(n2 - 1), (double)n9 / (double)(n2 - 1));
                JOGLTarget.setCameraMatrices(gL, camera);
                gL.glLightfv(16384, 4608, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0);
                gL.glLightfv(16384, 4609, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0);
                gL.glLightfv(16384, 4610, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0);
                gL.glLightfv(16384, 4611, new float[]{1.0f, 1.5f, 1.0f, 0.0f}, 0);
                gL.glEnable(16384);
                gL.glEnable(2896);
                gL.glPolygonMode(1032, 6914);
                new JOGLPrimitiveBufferRenderer(gL, primitiveBuffer).render();
                BufferedImage bufferedImage2 = Screenshot.readToBufferedImage((int)n7, (int)n10);
                bufferedImage.getGraphics().drawImage(bufferedImage2, n5, n2 - 1 - n9, null);
                gLPbuffer.getContext().release();
                gLPbuffer.destroy();
                gLPbuffer = null;
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }
}

