/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatLonEle {
    public final double lat;
    public final double lon;
    public final double ele;
    private static final String DOUBLE_P = "[+-]?\\d+(?:\\.\\d+)?";
    public static final String PATTERN = "([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?)";
    public static final String PATTERN_WITH_ELE = "([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?)";

    public LatLonEle(double d, double d2, double d3) {
        this.lat = d;
        this.lon = d2;
        this.ele = d3;
        this.validateValues();
    }

    public LatLonEle(double d, double d2) {
        this(d, d2, 0.0);
    }

    public LatLonEle(String string) {
        Matcher matcher = Pattern.compile(PATTERN_WITH_ELE).matcher(string);
        Matcher matcher2 = Pattern.compile(PATTERN).matcher(string);
        if (matcher.matches()) {
            this.lat = Double.parseDouble(matcher.group(1));
            this.lon = Double.parseDouble(matcher.group(2));
            this.ele = Double.parseDouble(matcher.group(3));
            this.validateValues();
        } else if (matcher2.matches()) {
            this.lat = Double.parseDouble(matcher2.group(1));
            this.lon = Double.parseDouble(matcher2.group(2));
            this.ele = 0.0;
            this.validateValues();
        } else {
            throw new IllegalArgumentException("argument doesn't match: " + string);
        }
    }

    private void validateValues() {
        if (this.lat > 90.0 || this.lat < -90.0 || this.lon > 180.0 || this.lon < -180.0) {
            throw new IllegalArgumentException("not valid: " + this.lat + ", " + this.lon);
        }
    }

    public String toString() {
        return this.lat + "," + this.lon;
    }
}

