/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.osm2world.console.CLIArguments;
import org.osm2world.console.CLIArgumentsGroup;
import org.osm2world.console.CLIArgumentsUtil;
import org.osm2world.console.Output;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.CliFactory;

public class OSM2World {
    public static void main(String[] stringArray) {
        List<Object> list;
        if (stringArray.length == 0) {
            System.out.println("No parameters, running graphical interface.\nIf you want to use the command line, use the --help parameter for a list of available parameters.");
            stringArray = new String[]{"--gui"};
        }
        CLIArguments cLIArguments = null;
        try {
            cLIArguments = OSM2World.parseArguments(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        List<CLIArguments> list2 = Collections.singletonList(cLIArguments);
        if (cLIArguments.isParameterFile()) {
            list2 = new ArrayList<CLIArguments>();
            try {
                list = CLIArgumentsUtil.getUnparsedParameterGroups(cLIArguments.getParameterFile());
                for (String[] stringArray2 : list) {
                    try {
                        list2.add(OSM2World.parseArguments(stringArray2));
                    }
                    catch (Exception exception) {
                        System.err.println("Could not parse parameters from file:");
                        System.err.println(stringArray2);
                        System.err.println("Ignoring it. Reason:");
                        System.err.println(exception.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                System.exit(1);
            }
        }
        list = new ArrayList();
        for (CLIArguments cLIArguments2 : list2) {
            boolean bl = false;
            for (CLIArgumentsGroup cLIArgumentsGroup : list) {
                if (!cLIArgumentsGroup.isCompatible(cLIArguments2)) continue;
                cLIArgumentsGroup.addCLIArguments(cLIArguments2);
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(new CLIArgumentsGroup(cLIArguments2));
        }
        for (CLIArgumentsGroup cLIArgumentsGroup : list) {
            if (list2.size() > 1) {
                System.out.print("executing conversion for these parameter lines: ");
                for (CLIArguments cLIArguments3 : cLIArgumentsGroup.getCLIArgumentsList()) {
                    System.out.print(list2.indexOf(cLIArguments3) + " ");
                }
                System.out.print("\n");
            }
            OSM2World.executeArgumentsGroup(cLIArgumentsGroup);
        }
    }

    private static CLIArguments parseArguments(String[] stringArray) throws ArgumentValidationException, Exception {
        CLIArguments cLIArguments = (CLIArguments)CliFactory.parseArguments(CLIArguments.class, (String[])stringArray);
        if (!CLIArgumentsUtil.isValid(cLIArguments)) {
            throw new Exception(CLIArgumentsUtil.getErrorString(cLIArguments));
        }
        return cLIArguments;
    }

    private static void executeArgumentsGroup(CLIArgumentsGroup cLIArgumentsGroup) {
        BaseConfiguration baseConfiguration = new BaseConfiguration();
        if (cLIArgumentsGroup.getRepresentative().isConfig()) {
            try {
                baseConfiguration = new PropertiesConfiguration(cLIArgumentsGroup.getRepresentative().getConfig());
            }
            catch (ConfigurationException configurationException) {
                System.err.println("could not read config, ignoring it: ");
                System.err.println(configurationException);
            }
        }
        CLIArgumentsUtil.ProgramMode programMode = CLIArgumentsUtil.getProgramMode(cLIArgumentsGroup.getRepresentative());
        switch (programMode) {
            case HELP: {
                System.out.println(CliFactory.createCli(CLIArguments.class).getHelpMessage() + "\n\nFor more information, see " + "http://wiki.osm.org/OSM2World");
                break;
            }
            case VERSION: {
                System.out.println("OSM2World 0.1.8");
                break;
            }
            case GUI: {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    System.out.println("Error setting native look and feel: " + exception);
                }
                new ViewerFrame(new Data(), new MessageManager(), new RenderOptions(), baseConfiguration).setVisible(true);
                break;
            }
            case CONVERT: {
                try {
                    Output.output(baseConfiguration, cLIArgumentsGroup);
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

