/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.osm2world.console.CLIArguments;
import org.osm2world.console.CLIArgumentsGroup;
import org.osm2world.console.CLIArgumentsUtil;
import org.osm2world.console.ImageExport;
import org.osm2world.console.LatLonEle;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.map_elevation.creation.EleTagElevationCalculator;
import org.osm2world.core.map_elevation.creation.ForceElevationCalculator;
import org.osm2world.core.map_elevation.creation.LevelTagElevationCalculator;
import org.osm2world.core.map_elevation.creation.ZeroElevationCalculator;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.OrthoTilesUtil;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.obj.ObjWriter;
import org.osm2world.core.target.povray.POVRayWriter;

public final class Output {
    private Output() {
    }

    public static void output(Configuration configuration, CLIArgumentsGroup cLIArgumentsGroup) throws IOException {
        long l = System.currentTimeMillis();
        ConversionFacade conversionFacade = new ConversionFacade();
        PerformanceListener performanceListener = new PerformanceListener(cLIArgumentsGroup.getRepresentative());
        conversionFacade.addProgressListener(performanceListener);
        String string = configuration.getString("elevationCalculator", "ZeroElevationCalculator");
        if ("ZeroElevationCalculator".equals(string)) {
            conversionFacade.setElevationCalculator(new ZeroElevationCalculator());
        } else if ("ForceElevationCalculator".equals(string)) {
            conversionFacade.setElevationCalculator(new ForceElevationCalculator());
        } else if ("EleTagElevationCalculator".equals(string)) {
            conversionFacade.setElevationCalculator(new EleTagElevationCalculator());
        } else if ("LevelTagElevationCalculator".equals(string)) {
            conversionFacade.setElevationCalculator(new LevelTagElevationCalculator());
        }
        ConversionFacade.Results results = conversionFacade.createRepresentations(cLIArgumentsGroup.getRepresentative().getInput(), null, configuration, null);
        for (CLIArguments cLIArguments : cLIArgumentsGroup.getCLIArgumentsList()) {
            Serializable serializable;
            Object object;
            Camera camera = null;
            Projection projection = null;
            if (cLIArguments.isOviewTiles()) {
                camera = OrthoTilesUtil.cameraForTiles(results.getMapProjection(), cLIArguments.getOviewTiles(), cLIArguments.getOviewAngle(), cLIArguments.getOviewFrom());
                projection = OrthoTilesUtil.projectionForTiles(results.getMapProjection(), cLIArguments.getOviewTiles(), cLIArguments.getOviewAngle(), cLIArguments.getOviewFrom());
            } else if (cLIArguments.isOviewBoundingBox()) {
                double d = cLIArguments.getOviewAngle();
                object = cLIArguments.getOviewFrom();
                serializable = new ArrayList<VectorXZ>();
                for (LatLonEle latLonEle : cLIArguments.getOviewBoundingBox()) {
                    serializable.add(results.getMapProjection().calcPos(latLonEle.lat, latLonEle.lon));
                }
                AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = new AxisAlignedBoundingBoxXZ((Collection<? extends Vector3D>)((Object)serializable));
                camera = OrthoTilesUtil.cameraForBounds(axisAlignedBoundingBoxXZ, d, (OrthoTilesUtil.CardinalDirection)((Object)object));
                projection = OrthoTilesUtil.projectionForBounds(axisAlignedBoundingBoxXZ, d, (OrthoTilesUtil.CardinalDirection)((Object)object));
            } else if (cLIArguments.isPviewPos()) {
                MapProjection mapProjection = results.getMapProjection();
                LatLonEle latLonEle = cLIArguments.getPviewPos();
                object = cLIArguments.getPviewLookat();
                camera = new Camera();
                camera.setPos(mapProjection.calcPos(latLonEle.lat, latLonEle.lon).xyz(latLonEle.ele));
                camera.setLookAt(mapProjection.calcPos(((LatLonEle)object).lat, ((LatLonEle)object).lon).xyz(((LatLonEle)object).ele));
                projection = new Projection(false, cLIArguments.isPviewAspect() ? cLIArguments.getPviewAspect() : (double)cLIArguments.getResolution().x / (double)cLIArguments.getResolution().y, cLIArguments.getPviewFovy(), 0.0, 1.0, 50000.0);
            }
            for (File file : cLIArguments.getOutput()) {
                object = CLIArgumentsUtil.getOutputMode(file);
                switch (1.$SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode[((Enum)object).ordinal()]) {
                    case 1: {
                        serializable = configuration.getInteger("primitiveThresholdOBJ", null);
                        if (serializable == null) {
                            ObjWriter.writeObjFile(file, results.getMapData(), results.getEleData(), results.getTerrain(), results.getMapProjection(), camera, projection);
                            break;
                        }
                        ObjWriter.writeObjFiles(file, results.getMapData(), results.getEleData(), results.getTerrain(), results.getMapProjection(), camera, projection, (Integer)serializable);
                        break;
                    }
                    case 2: {
                        POVRayWriter.writePOVInstructionFile(file, results.getMapData(), results.getEleData(), results.getTerrain(), camera, projection);
                        break;
                    }
                    case 3: {
                        if (camera == null || projection == null) {
                            System.err.println("camera or projection missing");
                        }
                        ImageExport.writeImageFile(configuration, file, cLIArguments.getResolution().x, cLIArguments.getResolution().y, results, camera, projection);
                    }
                }
            }
        }
        if (cLIArgumentsGroup.getRepresentative().getPerformancePrint()) {
            long l2 = (System.currentTimeMillis() - l) / 1000L;
            System.out.println("finished after " + l2 + " s");
        }
        if (cLIArgumentsGroup.getRepresentative().isPerformanceTable()) {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(cLIArgumentsGroup.getRepresentative().getPerformanceTable(), true), true);
            printWriter.printf("|%6d |%6d |%6d |%6d |%6d |%6d |\n", (performanceListener.getPhaseDuration(ConversionFacade.Phase.MAP_DATA) + 500L) / 1000L, (performanceListener.getPhaseDuration(ConversionFacade.Phase.REPRESENTATION) + 500L) / 1000L, (performanceListener.getPhaseDuration(ConversionFacade.Phase.ELEVATION) + 500L) / 1000L, (performanceListener.getPhaseDuration(ConversionFacade.Phase.TERRAIN) + 500L) / 1000L, (System.currentTimeMillis() - performanceListener.getPhaseEnd(ConversionFacade.Phase.TERRAIN) + 500L) / 1000L, (System.currentTimeMillis() - l + 500L) / 1000L);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode;

        static {
            $SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode = new int[CLIArgumentsUtil.OutputMode.values().length];
            try {
                1.$SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode[CLIArgumentsUtil.OutputMode.OBJ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode[CLIArgumentsUtil.OutputMode.POV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$osm2world$console$CLIArgumentsUtil$OutputMode[CLIArgumentsUtil.OutputMode.PNG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static class PerformanceListener
    implements ConversionFacade.ProgressListener {
        private final CLIArguments args;
        private ConversionFacade.Phase currentPhase = null;
        private long currentPhaseStart;
        private Map<ConversionFacade.Phase, Long> phaseStarts = new HashMap<ConversionFacade.Phase, Long>();
        private Map<ConversionFacade.Phase, Long> phaseEnds = new HashMap<ConversionFacade.Phase, Long>();

        public PerformanceListener(CLIArguments cLIArguments) {
            this.args = cLIArguments;
        }

        public Long getPhaseStart(ConversionFacade.Phase phase) {
            return this.phaseStarts.get((Object)phase);
        }

        public Long getPhaseEnd(ConversionFacade.Phase phase) {
            return this.phaseEnds.get((Object)phase);
        }

        public Long getPhaseDuration(ConversionFacade.Phase phase) {
            return this.getPhaseEnd(phase) - this.getPhaseStart(phase);
        }

        @Override
        public void updatePhase(ConversionFacade.Phase phase) {
            this.phaseStarts.put(phase, System.currentTimeMillis());
            if (this.currentPhase != null) {
                this.phaseEnds.put(this.currentPhase, System.currentTimeMillis());
                if (this.args.getPerformancePrint()) {
                    long l = System.currentTimeMillis() - this.currentPhaseStart;
                    System.out.println("phase " + (Object)((Object)this.currentPhase) + " finished after " + l + " ms");
                }
            }
            this.currentPhase = phase;
            this.currentPhaseStart = System.currentTimeMillis();
        }
    }
}

