/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Resolution {
    public final int x;
    public final int y;
    public static final String PATTERN = "([0-9]{1,9}),([0-9]{1,9})";

    public Resolution(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.validateValues();
    }

    public Resolution(String string) {
        Matcher matcher = Pattern.compile(PATTERN).matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("argument doesn't match: " + string);
        }
        this.x = Integer.parseInt(matcher.group(1));
        this.y = Integer.parseInt(matcher.group(2));
        this.validateValues();
    }

    private void validateValues() {
        if (this.x <= 0 || this.y <= 0) {
            throw new IllegalArgumentException("not positive: " + this.x + ", " + this.y);
        }
    }

    public String toString() {
        return this.x + "," + this.y;
    }
}

