/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.heightmap.creation.EmptyTerrainElevationGrid;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.map_data.creation.HackMapProjection;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.map_data.creation.OSMToMapDataConverter;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.map_elevation.creation.ZeroElevationCalculator;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.osm.creation.JOSMFileHack;
import org.osm2world.core.osm.creation.OsmosisReader;
import org.osm2world.core.osm.data.OSMData;
import org.osm2world.core.target.Renderable;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.terrain.creation.TerrainCreator;
import org.osm2world.core.terrain.data.Terrain;
import org.osm2world.core.world.creation.WorldCreator;
import org.osm2world.core.world.creation.WorldModule;
import org.osm2world.core.world.modules.BarrierModule;
import org.osm2world.core.world.modules.BridgeModule;
import org.osm2world.core.world.modules.BuildingModule;
import org.osm2world.core.world.modules.InvisibleModule;
import org.osm2world.core.world.modules.ParkingModule;
import org.osm2world.core.world.modules.RailwayModule;
import org.osm2world.core.world.modules.RoadModule;
import org.osm2world.core.world.modules.StreetFurnitureModule;
import org.osm2world.core.world.modules.SurfaceAreaModule;
import org.osm2world.core.world.modules.TreeModule;
import org.osm2world.core.world.modules.TunnelModule;
import org.osm2world.core.world.modules.WaterModule;

public class ConversionFacade {
    private ElevationCalculator elevationCalculator = new ZeroElevationCalculator();
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();

    private static final List<WorldModule> createDefaultModuleList() {
        return Arrays.asList(new RoadModule(), new RailwayModule(), new BuildingModule(), new ParkingModule(), new TreeModule(), new StreetFurnitureModule(), new WaterModule(), new BarrierModule(), new BridgeModule(), new TunnelModule(), new SurfaceAreaModule(), new InvisibleModule());
    }

    public void setElevationCalculator(ElevationCalculator elevationCalculator) {
        this.elevationCalculator = elevationCalculator;
    }

    public Results createRepresentations(File file, List<WorldModule> list, Configuration configuration, List<Target<?>> list2) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("osmFile must not be null");
        }
        OSMData oSMData = null;
        boolean bl = false;
        if (JOSMFileHack.isJOSMGenerated(file)) {
            bl = true;
        } else {
            try {
                oSMData = new OsmosisReader(file).getData();
            }
            catch (IOException iOException) {
                System.out.println("could not read file, trying workaround for files created by JOSM");
                bl = true;
            }
        }
        if (bl) {
            File file2;
            try {
                file2 = JOSMFileHack.createTempOSMFile(file);
            }
            catch (Exception exception) {
                throw new IOException("could not read OSM file (not even with workaround for JOSM files)", exception);
            }
            oSMData = new OsmosisReader(file2).getData();
        }
        return this.createRepresentations(oSMData, list, configuration, list2);
    }

    public Results createRepresentations(OSMData oSMData, List<WorldModule> list, Configuration configuration, List<Target<?>> list2) throws IOException {
        if (oSMData == null) {
            throw new IllegalArgumentException("osmData must not be null");
        }
        this.updatePhase(Phase.MAP_DATA);
        HackMapProjection hackMapProjection = new HackMapProjection(oSMData);
        OSMToMapDataConverter oSMToMapDataConverter = new OSMToMapDataConverter(hackMapProjection);
        MapData mapData = oSMToMapDataConverter.createMapData(oSMData);
        this.updatePhase(Phase.REPRESENTATION);
        if (configuration == null) {
            configuration = new BaseConfiguration();
        }
        if (list == null) {
            list = ConversionFacade.createDefaultModuleList();
        }
        Materials.configureMaterials(configuration);
        WorldCreator worldCreator = new WorldCreator(configuration, list);
        worldCreator.addRepresentationsTo(mapData);
        this.updatePhase(Phase.ELEVATION);
        CellularTerrainElevation cellularTerrainElevation = ConversionFacade.createEleData(mapData);
        this.elevationCalculator.calculateElevations(mapData, cellularTerrainElevation);
        this.updatePhase(Phase.TERRAIN);
        Terrain terrain = null;
        if (configuration.getBoolean("createTerrain", true)) {
            terrain = new TerrainCreator().createTerrain(mapData, cellularTerrainElevation);
        }
        this.updatePhase(Phase.FINISHED);
        if (list2 != null) {
            for (Target<?> target : list2) {
                TargetUtil.renderWorldObjects(target, mapData);
                if (terrain == null) continue;
                TargetUtil.renderObject(target, terrain);
            }
        }
        return new Results(hackMapProjection, mapData, terrain, cellularTerrainElevation);
    }

    private static CellularTerrainElevation createEleData(MapData mapData) {
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = mapData.getBoundary().pad(10.0);
        int n = Math.max(2, (int)(axisAlignedBoundingBoxXZ.sizeX() / 30.0));
        int n2 = Math.max(2, (int)(axisAlignedBoundingBoxXZ.sizeZ() / 30.0));
        EmptyTerrainElevationGrid emptyTerrainElevationGrid = new EmptyTerrainElevationGrid(axisAlignedBoundingBoxXZ, n, n2);
        return emptyTerrainElevationGrid;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    private void updatePhase(Phase phase) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.updatePhase(phase);
        }
    }

    public static interface ProgressListener {
        public void updatePhase(Phase var1);
    }

    public static enum Phase {
        MAP_DATA,
        REPRESENTATION,
        ELEVATION,
        TERRAIN,
        FINISHED;

    }

    public static final class Results {
        private final MapProjection mapProjection;
        private final MapData map;
        private final Terrain terrain;
        private final CellularTerrainElevation eleData;

        public Results(MapProjection mapProjection, MapData mapData, Terrain terrain, CellularTerrainElevation cellularTerrainElevation) {
            this.mapProjection = mapProjection;
            this.map = mapData;
            this.terrain = terrain;
            this.eleData = cellularTerrainElevation;
        }

        public MapProjection getMapProjection() {
            return this.mapProjection;
        }

        public MapData getMapData() {
            return this.map;
        }

        public Terrain getTerrain() {
            return this.terrain;
        }

        public CellularTerrainElevation getEleData() {
            return this.eleData;
        }

        public <R extends Renderable> Collection<R> getRenderables(Class<R> clazz) {
            return this.getRenderables(clazz, true, true);
        }

        public <R extends Renderable> Collection<R> getRenderables(Class<R> clazz, boolean bl, boolean bl2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (bl) {
                for (Renderable renderable : this.map.getWorldObjects(clazz)) {
                    arrayList.add(renderable);
                }
            }
            if (bl2 && this.terrain != null && clazz.isAssignableFrom(Terrain.class)) {
                Terrain terrain = this.terrain;
                arrayList.add(terrain);
            }
            return arrayList;
        }
    }
}

