/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.heightmap.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainElevationCell;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public abstract class AbstractCellularTerrainElevation
implements CellularTerrainElevation {
    final int numPointsX;
    final int numPointsZ;
    final Collection<TerrainPoint> terrainPoints;
    final TerrainPoint[][] terrainPointGrid;

    @Override
    public Collection<TerrainPoint> getTerrainPoints() {
        return this.terrainPoints;
    }

    @Override
    public TerrainPoint[][] getTerrainPointGrid() {
        return this.terrainPointGrid;
    }

    @Override
    public PolygonXYZ getBoundaryPolygon() {
        int n;
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        for (n = 0; n < this.numPointsX; ++n) {
            arrayList.add(this.vectorXYZForPointAt(n, 0));
        }
        for (n = 1; n < this.numPointsZ - 1; ++n) {
            arrayList.add(this.vectorXYZForPointAt(this.numPointsX - 1, n));
        }
        for (n = this.numPointsX - 1; n >= 0; --n) {
            arrayList.add(this.vectorXYZForPointAt(n, this.numPointsZ - 1));
        }
        for (n = this.numPointsZ - 2; n >= 0; --n) {
            arrayList.add(this.vectorXYZForPointAt(0, n));
        }
        return new PolygonXYZ(arrayList);
    }

    @Override
    public PolygonXZ getBoundaryPolygonXZ() {
        int n;
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>();
        for (n = 0; n < this.numPointsX; ++n) {
            arrayList.add(this.vectorXZForPointAt(n, 0));
        }
        for (n = 1; n < this.numPointsZ - 1; ++n) {
            arrayList.add(this.vectorXZForPointAt(this.numPointsX - 1, n));
        }
        for (n = this.numPointsX - 1; n >= 0; --n) {
            arrayList.add(this.vectorXZForPointAt(n, this.numPointsZ - 1));
        }
        for (n = this.numPointsZ - 2; n >= 0; --n) {
            arrayList.add(this.vectorXZForPointAt(0, n));
        }
        return new PolygonXZ(arrayList);
    }

    private VectorXYZ vectorXYZForPointAt(int n, int n2) {
        TerrainPoint terrainPoint = this.terrainPointGrid[n][n2];
        return terrainPoint.getPos().xyz(terrainPoint.getEle().floatValue());
    }

    private VectorXZ vectorXZForPointAt(int n, int n2) {
        TerrainPoint terrainPoint = this.terrainPointGrid[n][n2];
        return terrainPoint.getPos();
    }

    @Override
    public Iterable<? extends TerrainElevationCell> getCells() {
        return new Iterable<CellImpl>(){

            @Override
            public Iterator<CellImpl> iterator() {
                return new CellIterator();
            }
        };
    }

    public AbstractCellularTerrainElevation(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, int n, int n2) {
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException("need at least 2x2 points for cell grid");
        }
        this.numPointsX = n;
        this.numPointsZ = n2;
        this.terrainPoints = new ArrayList<TerrainPoint>(n * n2);
        this.terrainPointGrid = new TerrainPoint[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                TerrainPoint terrainPoint;
                VectorXZ vectorXZ = new VectorXZ(axisAlignedBoundingBoxXZ.minX + (double)i * axisAlignedBoundingBoxXZ.sizeX() / (double)(n - 1), axisAlignedBoundingBoxXZ.minZ + (double)j * axisAlignedBoundingBoxXZ.sizeZ() / (double)(n2 - 1));
                this.terrainPointGrid[i][j] = terrainPoint = new TerrainPoint(vectorXZ, this.getElevation(vectorXZ));
                this.terrainPoints.add(terrainPoint);
            }
        }
    }

    protected abstract Float getElevation(VectorXZ var1);

    private final class CellImpl
    implements TerrainElevationCell {
        private int leftXIndex;
        private int bottomZIndex;

        public CellImpl(int n, int n2) {
            assert (n + 1 < AbstractCellularTerrainElevation.this.numPointsX && n2 + 1 < AbstractCellularTerrainElevation.this.numPointsZ);
            this.leftXIndex = n;
            this.bottomZIndex = n2;
        }

        @Override
        public final TerrainPoint getBottomLeft() {
            return AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex][this.bottomZIndex];
        }

        @Override
        public final TerrainPoint getTopLeft() {
            return AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex][this.bottomZIndex + 1];
        }

        @Override
        public final TerrainPoint getBottomRight() {
            return AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex + 1][this.bottomZIndex];
        }

        @Override
        public final TerrainPoint getTopRight() {
            return AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex + 1][this.bottomZIndex + 1];
        }

        @Override
        public Collection<TerrainPoint> getTerrainPoints() {
            ArrayList<TerrainPoint> arrayList = new ArrayList<TerrainPoint>(4);
            arrayList.add(AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex][this.bottomZIndex]);
            arrayList.add(AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex + 1][this.bottomZIndex]);
            arrayList.add(AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex + 1][this.bottomZIndex + 1]);
            arrayList.add(AbstractCellularTerrainElevation.this.terrainPointGrid[this.leftXIndex][this.bottomZIndex + 1]);
            return arrayList;
        }

        @Override
        public final PolygonXYZ getPolygonXYZ() {
            ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(5);
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXYZForPointAt(this.leftXIndex, this.bottomZIndex));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXYZForPointAt(this.leftXIndex + 1, this.bottomZIndex));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXYZForPointAt(this.leftXIndex + 1, this.bottomZIndex + 1));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXYZForPointAt(this.leftXIndex, this.bottomZIndex + 1));
            arrayList.add((VectorXYZ)arrayList.get(0));
            return new PolygonXYZ(arrayList);
        }

        @Override
        public final SimplePolygonXZ getPolygonXZ() {
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(5);
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXZForPointAt(this.leftXIndex, this.bottomZIndex));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXZForPointAt(this.leftXIndex + 1, this.bottomZIndex));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXZForPointAt(this.leftXIndex + 1, this.bottomZIndex + 1));
            arrayList.add(AbstractCellularTerrainElevation.this.vectorXZForPointAt(this.leftXIndex, this.bottomZIndex + 1));
            arrayList.add((VectorXZ)arrayList.get(0));
            return new SimplePolygonXZ(arrayList);
        }

        @Override
        public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
            return new AxisAlignedBoundingBoxXZ(Math.min(this.getTopLeft().getPos().x, this.getBottomLeft().getPos().x), Math.min(this.getBottomLeft().getPos().z, this.getBottomRight().getPos().z), Math.max(this.getTopRight().getPos().x, this.getBottomRight().getPos().x), Math.max(this.getTopLeft().getPos().z, this.getTopRight().getPos().z));
        }

        public String toString() {
            return "cell at x: " + this.leftXIndex + ", z: " + this.bottomZIndex;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.bottomZIndex;
            n = 31 * n + this.leftXIndex;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CellImpl cellImpl = (CellImpl)object;
            if (!this.getOuterType().equals(cellImpl.getOuterType())) {
                return false;
            }
            if (this.bottomZIndex != cellImpl.bottomZIndex) {
                return false;
            }
            return this.leftXIndex == cellImpl.leftXIndex;
        }

        private AbstractCellularTerrainElevation getOuterType() {
            return AbstractCellularTerrainElevation.this;
        }
    }

    private final class CellIterator
    implements Iterator<CellImpl> {
        int currX = -1;
        int currZ = 0;

        private CellIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currX + 1 < AbstractCellularTerrainElevation.this.numPointsX - 1 || this.currZ + 2 < AbstractCellularTerrainElevation.this.numPointsZ - 1;
        }

        @Override
        public CellImpl next() {
            ++this.currX;
            if (this.currX == AbstractCellularTerrainElevation.this.numPointsX - 1) {
                ++this.currZ;
                this.currX = 0;
                if (this.currZ == AbstractCellularTerrainElevation.this.numPointsZ - 1) {
                    throw new NoSuchElementException();
                }
            }
            return new CellImpl(this.currX, this.currZ);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

