/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.creation;

import com.jhlabs.map.proj.MercatorProjection;
import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.osm.data.OSMData;
import org.osm2world.core.osm.data.OSMNode;

public class HackMapProjection
implements MapProjection {
    private final Projection projection = new MercatorProjection();
    private final Double firstNodeLat;
    private final Double firstNodeLon;
    public static final double SCALE_X = 70000.0;
    public static final double SCALE_Y = 110000.0;

    public HackMapProjection(OSMData oSMData) {
        if (oSMData.getNodes().isEmpty()) {
            throw new IllegalArgumentException("OSM data must contain nodes");
        }
        OSMNode oSMNode = oSMData.getNodes().iterator().next();
        this.firstNodeLat = oSMNode.lat;
        this.firstNodeLon = oSMNode.lon;
    }

    @Override
    public VectorXZ calcPos(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double();
        if (Double.isNaN(this.projection.project((double)(d2 -= this.firstNodeLon.doubleValue()), (double)(d -= this.firstNodeLat.doubleValue()), (Point2D.Double)double_).y * 110000.0)) {
            System.out.println("NaN!");
        }
        this.projection.project(d2, d, double_);
        return new VectorXZ(double_.x * 70000.0, double_.y * 110000.0);
    }

    @Override
    public double calcLat(VectorXZ vectorXZ) {
        if (vectorXZ.equals(VectorXZ.NULL_VECTOR)) {
            return this.firstNodeLat;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double calcLon(VectorXZ vectorXZ) {
        if (vectorXZ.equals(VectorXZ.NULL_VECTOR)) {
            return this.firstNodeLon;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorXZ getNorthUnit() {
        return VectorXZ.Z_UNIT;
    }
}

