/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.creation;

public final class MercatorProjection {
    private static final double R_MAJOR = 6378137.0;
    private static final double R_MINOR = 6356752.3142;
    private static final double RATIO = 0.996647189328169;
    private static final double ECCENT = Math.sqrt(0.006694380004260925);
    private static final double COM = 0.5 * ECCENT;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double RAD2Deg = 57.29577951308232;
    private static final double PI_2 = 1.5707963267948966;

    public static void main(String[] stringArray) {
        System.out.println(MercatorProjection.latToY(0.0));
        System.out.println(MercatorProjection.latToY(30.0));
        System.out.println(MercatorProjection.latToY(60.0));
        System.out.println(MercatorProjection.latToY(90.0));
        System.out.println(MercatorProjection.lonToX(0.0));
        System.out.println(MercatorProjection.lonToX(90.0));
        System.out.println(MercatorProjection.lonToX(180.0));
    }

    private MercatorProjection() {
    }

    public static double lonToX(double d) {
        return 6378137.0 * MercatorProjection.DegToRad(d);
    }

    public static double latToY(double d) {
        d = Math.min(89.5, Math.max(d, -89.5));
        double d2 = MercatorProjection.DegToRad(d);
        double d3 = Math.sin(d2);
        double d4 = ECCENT * d3;
        d4 = Math.pow((1.0 - d4) / (1.0 + d4), COM);
        double d5 = Math.tan(0.5 * (1.5707963267948966 - d2)) / d4;
        return 0.0 - 6378137.0 * Math.log(d5);
    }

    public static double xToLon(double d) {
        return MercatorProjection.RadToDeg(d) / 6378137.0;
    }

    public static double yToLat(double d) {
        double d2 = Math.exp(-d / 6378137.0);
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d2);
        double d4 = 1.0;
        for (int i = 0; Math.abs(d4) > 1.0E-9 && i < 15; ++i) {
            double d5 = ECCENT * Math.sin(d3);
            d4 = 1.5707963267948966 - 2.0 * Math.atan(d2 * Math.pow((1.0 - d5) / (1.0 + d5), COM)) - d3;
            d3 += d4;
        }
        return MercatorProjection.RadToDeg(d3);
    }

    private static double RadToDeg(double d) {
        return d * 57.29577951308232;
    }

    private static double DegToRad(double d) {
        return d * (Math.PI / 180);
    }
}

