/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.creation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapQuadtree;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapIntersectionWW;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_data.data.overlaps.MapOverlapAA;
import org.osm2world.core.map_data.data.overlaps.MapOverlapType;
import org.osm2world.core.map_data.data.overlaps.MapOverlapWA;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.osm.data.OSMData;
import org.osm2world.core.osm.data.OSMMember;
import org.osm2world.core.osm.data.OSMNode;
import org.osm2world.core.osm.data.OSMRelation;
import org.osm2world.core.osm.data.OSMWay;
import org.osm2world.core.osm.ruleset.HardcodedRuleset;
import org.osm2world.core.osm.ruleset.Ruleset;

public class OSMToMapDataConverter {
    private final Ruleset ruleset = new HardcodedRuleset();
    private final MapProjection mapProjection;
    private static final Tag MULTIPOLYON_TAG = new Tag("type", "multipolygon");

    public OSMToMapDataConverter(MapProjection mapProjection) {
        this.mapProjection = mapProjection;
    }

    public MapData createMapData(OSMData oSMData) throws IOException {
        ArrayList<MapNode> arrayList = new ArrayList<MapNode>();
        ArrayList<MapWaySegment> arrayList2 = new ArrayList<MapWaySegment>();
        ArrayList<MapArea> arrayList3 = new ArrayList<MapArea>();
        this.createGridElements(oSMData, arrayList, arrayList2, arrayList3);
        MapData mapData = new MapData(arrayList, arrayList2, arrayList3);
        OSMToMapDataConverter.calculateIntersectionsInMapData(mapData);
        return mapData;
    }

    private void createGridElements(OSMData oSMData, List<MapNode> list, List<MapWaySegment> list2, List<MapArea> list3) {
        Iterator<OSMNode> iterator;
        Object object;
        HashMap<OSMNode, Object> hashMap = new HashMap<OSMNode, Object>();
        for (OSMNode iterator2 : oSMData.getNodes()) {
            VectorXZ vectorXZ = this.mapProjection.calcPos(iterator2.lat, iterator2.lon);
            object = new MapNode(vectorXZ, iterator2);
            list.add((MapNode)object);
            hashMap.put(iterator2, object);
        }
        HashMap hashMap2 = new HashMap();
        block1: for (OSMWay oSMWay : oSMData.getWays()) {
            if (!oSMWay.isClosed()) continue;
            for (Object object2 : oSMWay.tags) {
                if (!this.ruleset.isAreaTag((Tag)object2)) continue;
                MapArea mapArea = new MapArea(oSMWay);
                list3.add(mapArea);
                for (OSMNode oSMNode : oSMWay.nodes) {
                    iterator = (MapNode)hashMap.get(oSMNode);
                    mapArea.addBoundaryNode((MapNode)((Object)iterator));
                    ((MapNode)((Object)iterator)).addAdjacentArea(mapArea);
                }
                hashMap2.put(oSMWay, mapArea);
                continue block1;
            }
        }
        for (OSMRelation oSMRelation : oSMData.getRelations()) {
            Object object2;
            if (!oSMRelation.tags.contains(MULTIPOLYON_TAG)) continue;
            object = null;
            object2 = new ArrayList();
            for (OSMMember oSMMember : oSMRelation.relationMembers) {
                if ("inner".equals(oSMMember.role)) {
                    OSMWay oSMWay;
                    if (!(oSMMember.member instanceof OSMWay) || !(oSMWay = (OSMWay)oSMMember.member).isClosed()) continue;
                    iterator = new ArrayList(oSMWay.nodes.size());
                    for (OSMNode oSMNode : ((OSMWay)oSMMember.member).nodes) {
                        iterator.add((OSMNode)hashMap.get(oSMNode));
                    }
                    object2.add((Object)iterator);
                    continue;
                }
                if (!"outer".equals(oSMMember.role) || !(oSMMember.member instanceof OSMWay)) continue;
                OSMWay oSMWay = (OSMWay)oSMMember.member;
                if (object != null || !oSMWay.isClosed()) continue;
                if (hashMap2.containsKey(oSMWay)) {
                    object = (MapArea)hashMap2.get(oSMMember.member);
                    continue;
                }
                object = new MapArea(oSMRelation, oSMWay);
                for (OSMNode oSMNode : oSMWay.nodes) {
                    MapNode mapNode = (MapNode)hashMap.get(oSMNode);
                    ((MapArea)object).addBoundaryNode(mapNode);
                    mapNode.addAdjacentArea((MapArea)object);
                }
                list3.add((MapArea)object);
                hashMap2.put(oSMWay, object);
            }
            if (object == null) continue;
            ((MapArea)object).setHoles((Collection<List<MapNode>>)object2);
        }
        for (MapNode mapNode : hashMap.values()) {
            mapNode.calculateAdjacentAreaSegments();
        }
        for (OSMWay oSMWay : oSMData.getWays()) {
            if (hashMap2.containsKey(oSMWay) && (oSMWay.tags.size() <= 0 || ((MapArea)hashMap2.get(oSMWay)).getOsmObject() == oSMWay) || oSMWay.tags.size() <= 0) continue;
            object = null;
            for (OSMNode oSMNode : oSMWay.nodes) {
                if (object != null) {
                    MapWaySegment mapWaySegment = new MapWaySegment(oSMWay, (MapNode)hashMap.get(object), (MapNode)hashMap.get(oSMNode));
                    list2.add(mapWaySegment);
                    ((MapNode)hashMap.get(object)).addOutboundLine(mapWaySegment);
                    ((MapNode)hashMap.get(oSMNode)).addInboundLine(mapWaySegment);
                }
                object = oSMNode;
            }
        }
    }

    private static void calculateIntersectionsInMapData(MapData mapData) {
        MapQuadtree mapQuadtree = new MapQuadtree(mapData);
        for (MapQuadtree.QuadLeaf quadLeaf : mapQuadtree.getLeaves()) {
            for (MapElement mapElement : quadLeaf.getElements()) {
                block2: for (MapElement mapElement2 : quadLeaf.getElements()) {
                    if (mapElement == mapElement2) continue;
                    for (MapOverlap<? extends MapElement, ? extends MapElement> mapOverlap : mapElement.getOverlaps()) {
                        if (mapOverlap.getOther(mapElement) != mapElement2) continue;
                        continue block2;
                    }
                    if (mapElement instanceof MapWaySegment && mapElement2 instanceof MapWaySegment) {
                        OSMToMapDataConverter.addOverlapBetween((MapWaySegment)mapElement, (MapWaySegment)mapElement2);
                        continue;
                    }
                    if (mapElement instanceof MapWaySegment && mapElement2 instanceof MapArea) {
                        OSMToMapDataConverter.addOverlapBetween((MapWaySegment)mapElement, (MapArea)mapElement2);
                        continue;
                    }
                    if (mapElement instanceof MapArea && mapElement2 instanceof MapWaySegment) {
                        OSMToMapDataConverter.addOverlapBetween((MapWaySegment)mapElement2, (MapArea)mapElement);
                        continue;
                    }
                    if (!(mapElement instanceof MapArea) || !(mapElement2 instanceof MapArea)) continue;
                    OSMToMapDataConverter.addOverlapBetween((MapArea)mapElement, (MapArea)mapElement2);
                }
            }
        }
    }

    private static void addOverlapBetween(MapWaySegment mapWaySegment, MapWaySegment mapWaySegment2) {
        if (mapWaySegment.isConnectedTo(mapWaySegment2)) {
            return;
        }
        VectorXZ vectorXZ = GeometryUtil.getLineSegmentIntersection(mapWaySegment.getStartNode().getPos(), mapWaySegment.getEndNode().getPos(), mapWaySegment2.getStartNode().getPos(), mapWaySegment2.getEndNode().getPos());
        if (vectorXZ != null) {
            MapIntersectionWW mapIntersectionWW = new MapIntersectionWW(mapWaySegment, mapWaySegment2, vectorXZ);
            mapWaySegment.addOverlap(mapIntersectionWW);
            mapWaySegment2.addOverlap(mapIntersectionWW);
        }
    }

    private static void addOverlapBetween(MapWaySegment mapWaySegment, MapArea mapArea) {
        boolean bl;
        boolean bl2;
        for (MapAreaSegment mapAreaSegment : mapArea.getAreaSegments()) {
            if (!mapAreaSegment.sharesBothNodes(mapWaySegment)) continue;
            MapOverlapWA mapOverlapWA = new MapOverlapWA(mapWaySegment, mapArea, MapOverlapType.SHARE_SEGMENT);
            mapWaySegment.addOverlap(mapOverlapWA);
            mapArea.addOverlap(mapOverlapWA);
            return;
        }
        Object object = mapWaySegment.getLineSegment();
        PolygonWithHolesXZ polygonWithHolesXZ = mapArea.getPolygon();
        if (!mapWaySegment.isConnectedTo(mapArea)) {
            bl2 = polygonWithHolesXZ.intersects((LineSegmentXZ)object);
            bl = !bl2 && polygonWithHolesXZ.contains((LineSegmentXZ)object);
        } else {
            bl2 = false;
            double d = VectorXZ.distance(((LineSegmentXZ)object).p1, ((LineSegmentXZ)object).p2);
            for (VectorXZ vectorXZ : polygonWithHolesXZ.intersectionPositions((LineSegmentXZ)object)) {
                if (!(VectorXZ.distance(vectorXZ, ((LineSegmentXZ)object).p1) > d / 100.0) || !(VectorXZ.distance(vectorXZ, ((LineSegmentXZ)object).p2) > d / 100.0)) continue;
                bl2 = true;
                break;
            }
            boolean bl3 = bl = !bl2 && polygonWithHolesXZ.contains(((LineSegmentXZ)object).getCenter());
        }
        if (bl || bl2) {
            object = new MapOverlapWA(mapWaySegment, mapArea, bl2 ? MapOverlapType.INTERSECT : MapOverlapType.CONTAIN);
            mapWaySegment.addOverlap((MapOverlap<?, ?>)object);
            mapArea.addOverlap((MapOverlap<?, ?>)object);
        }
    }

    private static void addOverlapBetween(MapArea mapArea, MapArea mapArea2) {
        boolean bl;
        for (MapAreaSegment mapAreaSegment : mapArea.getAreaSegments()) {
            for (MapAreaSegment object2 : mapArea2.getAreaSegments()) {
                if (!mapAreaSegment.sharesBothNodes(object2)) continue;
                MapOverlapAA hashSet = new MapOverlapAA(mapArea, mapArea2, MapOverlapType.SHARE_SEGMENT);
                mapArea.addOverlap(hashSet);
                mapArea2.addOverlap(hashSet);
                return;
            }
        }
        Object object3 = mapArea.getPolygon();
        PolygonWithHolesXZ polygonWithHolesXZ = mapArea2.getPolygon();
        HashSet<VectorXZ> hashSet = new HashSet<VectorXZ>();
        for (SimplePolygonXZ simplePolygonXZ : ((PolygonWithHolesXZ)object3).getPolygons()) {
            hashSet.addAll(simplePolygonXZ.getVertices());
        }
        HashSet hashSet2 = new HashSet();
        for (SimplePolygonXZ simplePolygonXZ : polygonWithHolesXZ.getPolygons()) {
            hashSet2.addAll(simplePolygonXZ.getVertices());
        }
        hashSet.retainAll(hashSet2);
        boolean bl2 = false;
        for (VectorXZ vectorXZ : ((PolygonWithHolesXZ)object3).intersectionPositions(polygonWithHolesXZ)) {
            boolean bl3 = true;
            for (VectorXZ vectorXZ2 : hashSet) {
                if (!(VectorXZ.distance(vectorXZ, vectorXZ2) < 0.01)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            bl2 = true;
            break;
        }
        boolean bl4 = bl = ((PolygonWithHolesXZ)object3).contains(polygonWithHolesXZ.getOuter()) || polygonWithHolesXZ.contains(polygonWithHolesXZ.getOuter());
        if (bl || bl2) {
            object3 = new MapOverlapAA(mapArea, mapArea2, bl2 ? MapOverlapType.INTERSECT : MapOverlapType.CONTAIN);
            mapArea.addOverlap((MapOverlap<?, ?>)object3);
            mapArea2.addOverlap((MapOverlap<?, ?>)object3);
        }
    }
}

