/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_elevation.data.AreaElevationProfile;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.osm.data.OSMElement;
import org.osm2world.core.osm.data.OSMWay;
import org.osm2world.core.world.data.AreaWorldObject;

public class MapArea
implements MapElement {
    private final List<MapNode> nodes;
    private final OSMElement objectWithTags;
    private final OSMWay osmWay;
    private List<List<MapNode>> holes = Collections.emptyList();
    private PolygonWithHolesXZ polygon;
    private Collection<MapAreaSegment> areaSegments;
    private Collection<MapOverlap<?, ?>> overlaps = Collections.EMPTY_LIST;
    private List<AreaWorldObject> representations = new ArrayList<AreaWorldObject>(1);
    private AreaElevationProfile elevationProfile;

    public MapArea(OSMElement oSMElement, OSMWay oSMWay) {
        this.objectWithTags = oSMElement;
        this.osmWay = oSMWay;
        this.nodes = new ArrayList<MapNode>();
    }

    public MapArea(OSMWay oSMWay) {
        this(oSMWay, oSMWay);
    }

    public void addBoundaryNode(MapNode mapNode) {
        this.nodes.add(mapNode);
    }

    public List<MapNode> getBoundaryNodes() {
        return this.nodes;
    }

    @Override
    public int getLayer() {
        if (this.osmWay.tags.containsKey("layer")) {
            try {
                return Integer.parseInt(this.osmWay.tags.getValue("layer"));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public void setHoles(Collection<List<MapNode>> collection) {
        this.holes = new ArrayList<List<MapNode>>(collection);
    }

    public Collection<List<MapNode>> getHoles() {
        return this.holes;
    }

    public OSMElement getOsmObject() {
        return this.objectWithTags;
    }

    public OSMWay getOsmWay() {
        return this.osmWay;
    }

    @Override
    public TagGroup getTags() {
        return this.objectWithTags.tags;
    }

    public PolygonWithHolesXZ getPolygon() {
        if (this.polygon == null) {
            try {
                SimplePolygonXZ simplePolygonXZ = MapArea.polygonFromGridNodeSequence(this.nodes);
                ArrayList<SimplePolygonXZ> arrayList = new ArrayList<SimplePolygonXZ>(this.holes.size());
                for (List<MapNode> list : this.holes) {
                    arrayList.add(MapArea.polygonFromGridNodeSequence(list));
                }
                this.polygon = new PolygonWithHolesXZ(simplePolygonXZ, arrayList);
            }
            catch (InvalidGeometryException invalidGeometryException) {
                throw new InvalidGeometryException("outer polygon is not simple for this object: " + this.objectWithTags, invalidGeometryException);
            }
        }
        return this.polygon;
    }

    public SimplePolygonXZ getOuterPolygon() {
        return this.polygon.getOuter();
    }

    private static SimplePolygonXZ polygonFromGridNodeSequence(List<MapNode> list) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(list.size());
        for (MapNode mapNode : list) {
            arrayList.add(mapNode.getPos());
        }
        return new SimplePolygonXZ(arrayList);
    }

    public Collection<MapAreaSegment> getAreaSegments() {
        if (this.areaSegments == null) {
            this.areaSegments = new ArrayList<MapAreaSegment>();
            int n = 0;
            while (n + 1 < this.nodes.size()) {
                this.areaSegments.add(new MapAreaSegment(this, this.getPolygon().getOuter().isClockwise(), this.nodes.get(n), this.nodes.get(n + 1)));
                ++n;
            }
            for (n = 0; n < this.holes.size(); ++n) {
                List<MapNode> list = this.holes.get(n);
                SimplePolygonXZ simplePolygonXZ = this.polygon.getHoles().get(n);
                int n2 = 0;
                while (n2 + 1 < list.size()) {
                    this.areaSegments.add(new MapAreaSegment(this, !simplePolygonXZ.isClockwise(), list.get(n2), list.get(n2 + 1)));
                    ++n2;
                }
            }
        }
        return this.areaSegments;
    }

    public List<AreaWorldObject> getRepresentations() {
        return this.representations;
    }

    @Override
    public AreaWorldObject getPrimaryRepresentation() {
        if (this.representations.isEmpty()) {
            return null;
        }
        return this.representations.get(0);
    }

    public void addRepresentation(AreaWorldObject areaWorldObject) {
        this.representations.add(areaWorldObject);
    }

    @Override
    public AreaElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public void setElevationProfile(AreaElevationProfile areaElevationProfile) {
        this.elevationProfile = areaElevationProfile;
    }

    public void addOverlap(MapOverlap<?, ?> mapOverlap) {
        assert (mapOverlap.e1 == this || mapOverlap.e2 == this);
        if (this.overlaps == Collections.EMPTY_LIST) {
            this.overlaps = new ArrayList();
        }
        this.overlaps.add(mapOverlap);
    }

    public Collection<MapOverlap<?, ?>> getOverlaps() {
        return this.overlaps;
    }

    public String toString() {
        return this.objectWithTags.toString();
    }
}

