/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.world.data.WorldObject;

public class MapData {
    final List<MapNode> mapNodes;
    final List<MapWaySegment> mapWaySegments;
    final List<MapArea> mapAreas;
    AxisAlignedBoundingBoxXZ boundary;

    public MapData(List<MapNode> list, List<MapWaySegment> list2, List<MapArea> list3) {
        this.mapNodes = list;
        this.mapWaySegments = list2;
        this.mapAreas = list3;
        this.calculateBoundary();
    }

    private void calculateBoundary() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (MapNode mapNode : this.mapNodes) {
            double d5 = mapNode.getPos().x;
            double d6 = mapNode.getPos().z;
            if (d5 < d) {
                d = d5;
            }
            if (d5 > d2) {
                d2 = d5;
            }
            if (d6 < d3) {
                d3 = d6;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        this.boundary = new AxisAlignedBoundingBoxXZ(d, d3, d2, d4);
    }

    public Iterable<MapElement> getMapElements() {
        return Iterables.concat(this.mapNodes, this.mapWaySegments, this.mapAreas);
    }

    public Collection<MapArea> getMapAreas() {
        return this.mapAreas;
    }

    public Collection<MapWaySegment> getMapWaySegments() {
        return this.mapWaySegments;
    }

    public Collection<MapNode> getMapNodes() {
        return this.mapNodes;
    }

    public AxisAlignedBoundingBoxXZ getBoundary() {
        return this.boundary;
    }

    public VectorXZ getCenter() {
        int n = this.getMapNodes().size();
        double d = 0.0;
        double d2 = 0.0;
        for (MapNode mapNode : this.getMapNodes()) {
            d += mapNode.getPos().x / (double)n;
            d2 += mapNode.getPos().z / (double)n;
        }
        return new VectorXZ(d, d2);
    }

    public Iterable<WorldObject> getWorldObjects() {
        return Iterables.concat(Iterables.transform(this.getMapElements(), new Function<MapElement, Iterable<? extends WorldObject>>(){

            @Override
            public Iterable<? extends WorldObject> apply(MapElement mapElement) {
                return mapElement.getRepresentations();
            }
        }));
    }

    public <T> Iterable<T> getWorldObjects(Class<T> clazz) {
        return Iterables.filter(this.getWorldObjects(), clazz);
    }
}

