/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.osm.data.OSMNode;
import org.osm2world.core.world.data.NodeWorldObject;

public class MapNode
implements MapElement {
    private final VectorXZ pos;
    private final OSMNode osmNode;
    private List<NodeWorldObject> representations = new ArrayList<NodeWorldObject>(1);
    private NodeElevationProfile elevationProfile;
    private List<MapWaySegment> connectedWaySegments = new ArrayList<MapWaySegment>();
    private List<MapSegment> connectedSegments = new ArrayList<MapSegment>();
    private List<MapWaySegment> inboundLines = new ArrayList<MapWaySegment>();
    private List<MapWaySegment> outboundLines = new ArrayList<MapWaySegment>();
    private Collection<MapArea> adjacentAreas;

    public MapNode(VectorXZ vectorXZ, OSMNode oSMNode) {
        this.pos = vectorXZ;
        this.osmNode = oSMNode;
        this.adjacentAreas = new ArrayList<MapArea>();
    }

    public VectorXZ getPos() {
        return this.pos;
    }

    @Override
    public int getLayer() {
        if (this.osmNode.tags.containsKey("layer")) {
            try {
                return Integer.parseInt(this.osmNode.tags.getValue("layer"));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public OSMNode getOsmNode() {
        return this.osmNode;
    }

    @Override
    public TagGroup getTags() {
        return this.getOsmNode().tags;
    }

    public Collection<MapArea> getAdjacentAreas() {
        return this.adjacentAreas;
    }

    public void addInboundLine(MapWaySegment mapWaySegment) {
        this.connectedWaySegments.add(mapWaySegment);
        this.connectedSegments.add(mapWaySegment);
        this.inboundLines.add(mapWaySegment);
        this.sortLinesByAngle(this.connectedWaySegments);
        this.sortLinesByAngle(this.connectedSegments);
        this.sortLinesByAngle(this.inboundLines);
    }

    public void addOutboundLine(MapWaySegment mapWaySegment) {
        this.connectedWaySegments.add(mapWaySegment);
        this.connectedSegments.add(mapWaySegment);
        this.outboundLines.add(mapWaySegment);
        this.sortLinesByAngle(this.connectedWaySegments);
        this.sortLinesByAngle(this.connectedSegments);
        this.sortLinesByAngle(this.outboundLines);
    }

    public List<MapWaySegment> getInboundLines() {
        return this.inboundLines;
    }

    public List<MapWaySegment> getOutboundLines() {
        return this.outboundLines;
    }

    public void addAdjacentArea(MapArea mapArea) {
        this.adjacentAreas.add(mapArea);
    }

    public void calculateAdjacentAreaSegments() {
        for (MapArea mapArea : this.adjacentAreas) {
            for (MapAreaSegment mapAreaSegment : mapArea.getAreaSegments()) {
                if (mapAreaSegment.getStartNode() != this && mapAreaSegment.getEndNode() != this) continue;
                this.connectedSegments.add(mapAreaSegment);
            }
        }
        this.sortLinesByAngle(this.connectedSegments);
    }

    public List<MapWaySegment> getConnectedWaySegments() {
        return this.connectedWaySegments;
    }

    public List<MapSegment> getConnectedSegments() {
        return this.connectedSegments;
    }

    private void sortLinesByAngle(List<? extends MapSegment> list) {
        Collections.sort(list, new Comparator<MapSegment>(){

            @Override
            public int compare(MapSegment mapSegment, MapSegment mapSegment2) {
                VectorXZ vectorXZ = mapSegment.getDirection();
                VectorXZ vectorXZ2 = mapSegment2.getDirection();
                if (MapNode.this.inboundLines.contains(mapSegment)) {
                    vectorXZ = vectorXZ.invert();
                }
                if (MapNode.this.inboundLines.contains(mapSegment2)) {
                    vectorXZ2 = vectorXZ2.invert();
                }
                if (vectorXZ.z < 0.0 && vectorXZ2.z > 0.0) {
                    return -1;
                }
                if (vectorXZ.z > 0.0 && vectorXZ2.z < 0.0) {
                    return 1;
                }
                double d = vectorXZ.dot(VectorXZ.X_UNIT) - vectorXZ2.dot(VectorXZ.X_UNIT);
                if (d == 0.0) {
                    return 0;
                }
                if (vectorXZ.z < 0.0) {
                    return d > 0.0 ? -1 : 1;
                }
                return d > 0.0 ? 1 : -1;
            }
        });
    }

    public List<NodeWorldObject> getRepresentations() {
        return this.representations;
    }

    @Override
    public NodeWorldObject getPrimaryRepresentation() {
        if (this.representations.isEmpty()) {
            return null;
        }
        return this.representations.get(0);
    }

    public void addRepresentation(NodeWorldObject nodeWorldObject) {
        this.representations.add(nodeWorldObject);
    }

    @Override
    public NodeElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public void setElevationProfile(NodeElevationProfile nodeElevationProfile) {
        this.elevationProfile = nodeElevationProfile;
    }

    public String toString() {
        return this.osmNode.toString();
    }

    public Collection<MapOverlap<?, ?>> getOverlaps() {
        return Collections.emptyList();
    }
}

