/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.util.FaultTolerantIterationUtil;

public class MapQuadtree {
    static final int LEAF_SPLIT_SIZE = 11;
    final QuadInnerNode root;

    public MapQuadtree(MapData mapData) {
        this.root = new QuadInnerNode(mapData.getBoundary().minX, mapData.getBoundary().maxX, mapData.getBoundary().minZ, mapData.getBoundary().maxZ);
        FaultTolerantIterationUtil.iterate(mapData.getMapElements(), new FaultTolerantIterationUtil.Operation<MapElement>(){

            @Override
            public void perform(MapElement mapElement) {
                MapQuadtree.this.root.add(mapElement);
            }
        });
    }

    public Iterable<QuadLeaf> getLeaves() {
        ArrayList<QuadLeaf> arrayList = new ArrayList<QuadLeaf>();
        this.root.collectLeaves(arrayList);
        return arrayList;
    }

    public class QuadLeaf
    extends QuadNode {
        final QuadInnerNode parent;
        final ArrayList<MapElement> elements;

        QuadLeaf(QuadInnerNode quadInnerNode, double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.parent = quadInnerNode;
            this.elements = new ArrayList(11);
        }

        public List<MapElement> getElements() {
            return this.elements;
        }

        @Override
        void add(MapElement mapElement) {
            this.elements.add(mapElement);
            if (this.elements.size() >= 11) {
                this.parent.trySplitLeaf(this);
            }
        }

        @Override
        void addAll(Collection<MapElement> collection) {
            this.elements.addAll(collection);
            if (this.elements.size() >= 11) {
                this.parent.trySplitLeaf(this);
            }
        }

        @Override
        void collectLeaves(List<QuadLeaf> list) {
            list.add(this);
        }
    }

    class QuadInnerNode
    extends QuadNode {
        final QuadNode[] childNodes;

        QuadInnerNode(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.childNodes = new QuadNode[4];
            double d5 = (d + d2) / 2.0;
            double d6 = (d3 + d4) / 2.0;
            this.childNodes[0] = new QuadLeaf(this, d, d5, d3, d6);
            this.childNodes[1] = new QuadLeaf(this, d5, d2, d3, d6);
            this.childNodes[2] = new QuadLeaf(this, d, d5, d6, d4);
            this.childNodes[3] = new QuadLeaf(this, d5, d2, d6, d4);
        }

        @Override
        void add(MapElement mapElement) {
            for (int i = 0; i < 4; ++i) {
                if (!this.childNodes[i].contains(mapElement)) continue;
                this.childNodes[i].add(mapElement);
            }
        }

        @Override
        void addAll(Collection<MapElement> collection) {
            for (MapElement mapElement : collection) {
                this.add(mapElement);
            }
        }

        void trySplitLeaf(QuadLeaf quadLeaf) {
            int n;
            QuadInnerNode quadInnerNode = new QuadInnerNode(quadLeaf.minX, quadLeaf.maxX, quadLeaf.minZ, quadLeaf.maxZ);
            boolean bl = true;
            for (n = 0; n < 4; ++n) {
                boolean bl2 = true;
                for (MapElement mapElement : quadLeaf.getElements()) {
                    if (quadInnerNode.childNodes[n].contains(mapElement)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n = 0; n < 4; ++n) {
                    if (this.childNodes[n] != quadLeaf) continue;
                    this.childNodes[n] = quadInnerNode;
                    this.childNodes[n].addAll(quadLeaf.elements);
                    return;
                }
                throw new AssertionError((Object)"leaf is not a child of this node");
            }
        }

        @Override
        void collectLeaves(List<QuadLeaf> list) {
            for (int i = 0; i < 4; ++i) {
                this.childNodes[i].collectLeaves(list);
            }
        }
    }

    static abstract class QuadNode {
        public final double minX;
        public final double maxX;
        public final double minZ;
        public final double maxZ;
        private final SimplePolygonXZ boundary;

        QuadNode(double d, double d2, double d3, double d4) {
            this.minX = d;
            this.maxX = d2;
            this.minZ = d3;
            this.maxZ = d4;
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(5);
            arrayList.add(new VectorXZ(d, d3));
            arrayList.add(new VectorXZ(d2, d3));
            arrayList.add(new VectorXZ(d2, d4));
            arrayList.add(new VectorXZ(d, d4));
            arrayList.add((VectorXZ)arrayList.get(0));
            this.boundary = new SimplePolygonXZ(arrayList);
        }

        boolean contains(MapElement mapElement) {
            if (mapElement instanceof MapNode) {
                return this.contains(((MapNode)mapElement).getPos());
            }
            if (mapElement instanceof MapWaySegment) {
                MapWaySegment mapWaySegment = (MapWaySegment)mapElement;
                VectorXZ vectorXZ = mapWaySegment.getStartNode().getPos();
                VectorXZ vectorXZ2 = mapWaySegment.getEndNode().getPos();
                if (this.contains(vectorXZ) || this.contains(vectorXZ2)) {
                    return true;
                }
                return this.boundary.intersects(vectorXZ, vectorXZ2);
            }
            MapArea mapArea = (MapArea)mapElement;
            for (MapNode mapNode : mapArea.getBoundaryNodes()) {
                if (!this.contains(mapNode.getPos())) continue;
                return true;
            }
            return this.boundary.intersects(mapArea.getPolygon().getOuter()) || mapArea.getPolygon().contains(this.boundary);
        }

        boolean contains(VectorXZ vectorXZ) {
            return vectorXZ.x >= this.minX && vectorXZ.x <= this.maxX && vectorXZ.z >= this.minZ && vectorXZ.z <= this.maxZ;
        }

        abstract void add(MapElement var1);

        abstract void addAll(Collection<MapElement> var1);

        abstract void collectLeaves(List<QuadLeaf> var1);
    }
}

