/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.VectorXZ;

public class MapSegment {
    protected final MapNode startNode;
    protected final MapNode endNode;
    private VectorXZ direction = null;
    private VectorXZ rightNormal = null;

    public MapSegment(MapNode mapNode, MapNode mapNode2) {
        if (mapNode == null || mapNode2 == null) {
            throw new IllegalArgumentException();
        }
        this.startNode = mapNode;
        this.endNode = mapNode2;
    }

    public MapNode getStartNode() {
        return this.startNode;
    }

    public MapNode getEndNode() {
        return this.endNode;
    }

    public MapNode getOtherNode(MapNode mapNode) {
        if (mapNode == this.startNode) {
            return this.endNode;
        }
        if (mapNode == this.endNode) {
            return this.startNode;
        }
        throw new IllegalArgumentException("not a node of this segment");
    }

    public List<MapNode> getStartEndNodes() {
        return ImmutableList.of(this.startNode, this.endNode);
    }

    public LineSegmentXZ getLineSegment() {
        return new LineSegmentXZ(this.startNode.getPos(), this.endNode.getPos());
    }

    public VectorXZ getDirection() {
        if (this.direction == null) {
            this.direction = this.endNode.getPos().subtract(this.startNode.getPos());
            this.direction = this.direction.normalize();
        }
        return this.direction;
    }

    public VectorXZ getRightNormal() {
        if (this.rightNormal == null) {
            this.rightNormal = this.getDirection().rightNormal();
        }
        return this.rightNormal;
    }

    public VectorXZ getCenter() {
        return this.startNode.getPos().add(this.endNode.getPos()).mult(0.5);
    }

    public boolean isConnectedTo(MapSegment mapSegment) {
        return this.endNode == mapSegment.getStartNode() || this.endNode == mapSegment.getEndNode() || this.startNode == mapSegment.getStartNode() || this.startNode == mapSegment.getEndNode();
    }

    public boolean isConnectedTo(MapArea mapArea) {
        return mapArea.getBoundaryNodes().contains(this.startNode) || mapArea.getBoundaryNodes().contains(this.endNode);
    }

    public boolean sharesBothNodes(MapSegment mapSegment) {
        return this.endNode == mapSegment.getStartNode() && this.startNode == mapSegment.getEndNode() || this.endNode == mapSegment.getEndNode() && this.startNode == mapSegment.getStartNode();
    }
}

