/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.overlaps.MapIntersectionWW;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;
import org.osm2world.core.osm.data.OSMWay;
import org.osm2world.core.world.data.WaySegmentWorldObject;

public class MapWaySegment
extends MapSegment
implements MapElement {
    private final OSMWay osmWay;
    private List<WaySegmentWorldObject> representations = new ArrayList<WaySegmentWorldObject>(1);
    private WaySegmentElevationProfile elevationProfile;
    private Collection<MapOverlap<?, ?>> overlaps = Collections.EMPTY_LIST;

    public MapWaySegment(OSMWay oSMWay, MapNode mapNode, MapNode mapNode2) {
        super(mapNode, mapNode2);
        this.osmWay = oSMWay;
    }

    @Override
    public int getLayer() {
        if (this.osmWay.tags.containsKey("layer")) {
            try {
                return Integer.parseInt(this.osmWay.tags.getValue("layer"));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public OSMWay getOsmWay() {
        return this.osmWay;
    }

    @Override
    public TagGroup getTags() {
        return this.getOsmWay().tags;
    }

    public void addOverlap(MapOverlap<?, ?> mapOverlap) {
        assert (mapOverlap.e1 == this || mapOverlap.e2 == this);
        if (this.overlaps == Collections.EMPTY_LIST) {
            this.overlaps = new ArrayList();
        }
        this.overlaps.add(mapOverlap);
    }

    public Collection<MapOverlap<?, ?>> getOverlaps() {
        return this.overlaps;
    }

    public Iterable<MapIntersectionWW> getIntersectionsWW() {
        return Iterables.filter(this.overlaps, MapIntersectionWW.class);
    }

    public List<WaySegmentWorldObject> getRepresentations() {
        return this.representations;
    }

    @Override
    public WaySegmentWorldObject getPrimaryRepresentation() {
        if (this.representations.isEmpty()) {
            return null;
        }
        return this.representations.get(0);
    }

    public void addRepresentation(WaySegmentWorldObject waySegmentWorldObject) {
        this.representations.add(waySegmentWorldObject);
    }

    @Override
    public WaySegmentElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public void setElevationProfile(WaySegmentElevationProfile waySegmentElevationProfile) {
        this.elevationProfile = waySegmentElevationProfile;
    }

    public String toString() {
        return this.startNode + "->" + this.endNode;
    }
}

