/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_data.data.overlaps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_data.data.overlaps.MapOverlapType;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.VectorXZ;

public class MapOverlapWA
extends MapOverlap<MapWaySegment, MapArea> {
    public MapOverlapWA(MapWaySegment mapWaySegment, MapArea mapArea, MapOverlapType mapOverlapType) {
        super(mapWaySegment, mapArea, mapOverlapType);
    }

    public MapArea getOther(MapWaySegment mapWaySegment) {
        return (MapArea)super.getOther(mapWaySegment);
    }

    public MapWaySegment getOther(MapArea mapArea) {
        return (MapWaySegment)super.getOther(mapArea);
    }

    public Collection<VectorXZ> getIntersectionPositions() {
        if (this.type == MapOverlapType.INTERSECT) {
            return ((MapArea)this.e2).getPolygon().intersectionPositions(((MapWaySegment)this.e1).getLineSegment());
        }
        return Collections.emptyList();
    }

    public Collection<LineSegmentXZ> getOverlappedSegments() {
        if (this.type == MapOverlapType.CONTAIN) {
            return Collections.singletonList(((MapWaySegment)this.e1).getLineSegment());
        }
        if (this.type == MapOverlapType.INTERSECT) {
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.getIntersectionPositions());
            arrayList.add(((MapWaySegment)this.e1).getStartNode().getPos());
            arrayList.add(((MapWaySegment)this.e1).getEndNode().getPos());
            Collections.sort(arrayList, new Comparator<VectorXZ>(){

                @Override
                public int compare(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
                    return Double.compare(VectorXZ.distance(vectorXZ, ((MapWaySegment)MapOverlapWA.this.e1).getStartNode().getPos()), VectorXZ.distance(vectorXZ2, ((MapWaySegment)MapOverlapWA.this.e1).getStartNode().getPos()));
                }
            });
            ArrayList<LineSegmentXZ> arrayList2 = new ArrayList<LineSegmentXZ>();
            int n = 0;
            while (n + 1 < arrayList.size()) {
                LineSegmentXZ lineSegmentXZ = new LineSegmentXZ((VectorXZ)arrayList.get(n), (VectorXZ)arrayList.get(n + 1));
                if (((MapArea)this.e2).getPolygon().contains(lineSegmentXZ.getCenter())) {
                    arrayList2.add(lineSegmentXZ);
                }
                ++n;
            }
            return arrayList2;
        }
        return Collections.emptyList();
    }

    public Collection<LineSegmentXZ> getSharedSegments() {
        if (this.type == MapOverlapType.SHARE_SEGMENT) {
            for (MapAreaSegment mapAreaSegment : ((MapArea)this.e2).getAreaSegments()) {
                if (!mapAreaSegment.sharesBothNodes((MapSegment)((Object)this.e1))) continue;
                return Collections.singletonList(mapAreaSegment.getLineSegment());
            }
            throw new Error("no shared segment found");
        }
        return Collections.emptyList();
    }
}

