/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.creation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapIntersectionWW;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_data.data.overlaps.MapOverlapAA;
import org.osm2world.core.map_data.data.overlaps.MapOverlapType;
import org.osm2world.core.map_data.data.overlaps.MapOverlapWA;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.map_elevation.data.AreaElevationProfile;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.world.data.WorldObject;

public abstract class AdvancedAbstractElevationCalculator
implements ElevationCalculator {
    @Override
    public void calculateElevations(MapData mapData, CellularTerrainElevation cellularTerrainElevation) {
        ElevationDeterminationScenario elevationDeterminationScenario = this.createScenario(cellularTerrainElevation);
        for (MapElement object : mapData.getMapElements()) {
            if (object.getPrimaryRepresentation() == null) continue;
            elevationDeterminationScenario.addElement(object);
            for (MapOverlap<? extends MapElement, ? extends MapElement> mapOverlap : object.getOverlaps()) {
                if (mapOverlap.e1.getPrimaryRepresentation() == null || mapOverlap.e2.getPrimaryRepresentation() == null) continue;
                elevationDeterminationScenario.addOverlap(mapOverlap);
            }
        }
        for (TerrainPoint terrainPoint : cellularTerrainElevation.getTerrainPoints()) {
            elevationDeterminationScenario.addTerrainPoint(terrainPoint);
        }
        elevationDeterminationScenario.calculate();
        elevationDeterminationScenario.writeResult();
    }

    protected abstract ElevationDeterminationScenario createScenario(CellularTerrainElevation var1);

    protected static abstract class AbstractElevationDeterminationScenario
    implements ElevationDeterminationScenario {
        private static final int DIST_INVISIBLE_NODES = 50;
        protected final Map<MapNode, ForceNodeOnNode> nodeMap = new HashMap<MapNode, ForceNodeOnNode>();
        protected final Multimap<MapWaySegment, ForceNode> lineMap = HashMultimap.create();
        protected final Multimap<MapArea, ForceNode> areaMap = HashMultimap.create();
        protected final Map<TerrainPoint, ForceNodeOnTerrainPoint> terrainPointMap = new HashMap<TerrainPoint, ForceNodeOnTerrainPoint>();
        protected final Set<MapOverlap<?, ?>> knownOverlaps = new HashSet();
        protected final Collection<ForceNode> forceNodes = new ArrayList<ForceNode>();

        protected AbstractElevationDeterminationScenario() {
        }

        @Override
        public final void addElement(MapElement mapElement) {
            if (mapElement instanceof MapNode) {
                this.addNode((MapNode)mapElement);
            } else if (mapElement instanceof MapWaySegment) {
                this.addWaySegment((MapWaySegment)mapElement);
            } else if (mapElement instanceof MapArea) {
                this.addArea((MapArea)mapElement);
            }
        }

        @Override
        public final void addOverlap(MapOverlap<?, ?> mapOverlap) {
            if (mapOverlap instanceof MapIntersectionWW) {
                this.addIntersectionWW((MapIntersectionWW)mapOverlap);
            } else if (mapOverlap instanceof MapOverlapWA) {
                this.addOverlapWA((MapOverlapWA)mapOverlap);
            } else if (mapOverlap instanceof MapOverlapAA) {
                this.addOverlapAA((MapOverlapAA)mapOverlap);
            }
        }

        @Override
        public final void addTerrainPoint(TerrainPoint terrainPoint) {
            if (this.terrainPointMap.containsKey(terrainPoint)) {
                return;
            }
            ForceNodeOnTerrainPoint forceNodeOnTerrainPoint = new ForceNodeOnTerrainPoint(terrainPoint);
            this.terrainPointMap.put(terrainPoint, forceNodeOnTerrainPoint);
            this.forceNodes.add(forceNodeOnTerrainPoint);
            if (terrainPoint.getEle() != null) {
                this.handleConstantElevation(forceNodeOnTerrainPoint, terrainPoint.getEle(), false);
            }
        }

        private final void addNode(MapNode mapNode) {
            if (this.nodeMap.containsKey(mapNode)) {
                return;
            }
            ForceNodeOnNode forceNodeOnNode = new ForceNodeOnNode(mapNode);
            this.nodeMap.put(mapNode, forceNodeOnNode);
            this.forceNodes.add(forceNodeOnNode);
            if (mapNode.getTags().containsKey("ele")) {
                Float f = ValueStringParser.parseOsmDecimal(mapNode.getTags().getValue("ele"), true);
                this.handleConstantElevation(forceNodeOnNode, f, true);
            }
            mapNode.setElevationProfile(new NodeElevationProfile(mapNode));
        }

        private final void addWaySegment(MapWaySegment mapWaySegment) {
            if (this.lineMap.containsKey(mapWaySegment)) {
                return;
            }
            ArrayList<ForceNode> arrayList = new ArrayList<ForceNode>();
            this.addNode(mapWaySegment.getStartNode());
            this.addNode(mapWaySegment.getEndNode());
            arrayList.add(this.nodeMap.get(mapWaySegment.getStartNode()));
            arrayList.add(this.nodeMap.get(mapWaySegment.getEndNode()));
            if (mapWaySegment.getLineSegment().getLength() > 50.0) {
                List<VectorXZ> list = GeometryUtil.equallyDistributePointsAlong(50.0, false, mapWaySegment.getStartNode().getPos(), mapWaySegment.getEndNode().getPos());
                for (VectorXZ vectorXZ : list) {
                    ForceNodeOnLine forceNodeOnLine = new ForceNodeOnLine(mapWaySegment, vectorXZ);
                    this.forceNodes.add(forceNodeOnLine);
                    arrayList.add(forceNodeOnLine);
                }
            }
            this.lineMap.putAll(mapWaySegment, arrayList);
            mapWaySegment.setElevationProfile(new WaySegmentElevationProfile(mapWaySegment));
        }

        private final void addArea(MapArea mapArea) {
            if (this.areaMap.containsKey(mapArea)) {
                return;
            }
            ArrayList<ForceNodeOnNode> arrayList = new ArrayList<ForceNodeOnNode>();
            for (MapNode object : mapArea.getBoundaryNodes()) {
                this.addNode(object);
                arrayList.add(this.nodeMap.get(object));
            }
            for (List list : mapArea.getHoles()) {
                for (MapNode mapNode : list) {
                    this.addNode(mapNode);
                    arrayList.add(this.nodeMap.get(mapNode));
                }
            }
            this.areaMap.putAll(mapArea, arrayList);
            mapArea.setElevationProfile(new AreaElevationProfile(mapArea));
        }

        private final void addIntersectionWW(MapIntersectionWW mapIntersectionWW) {
            if (this.knownOverlaps.contains(mapIntersectionWW)) {
                return;
            }
            this.knownOverlaps.add(mapIntersectionWW);
            MapWaySegment mapWaySegment = (MapWaySegment)mapIntersectionWW.e1;
            MapWaySegment mapWaySegment2 = (MapWaySegment)mapIntersectionWW.e2;
            VectorXZ vectorXZ = mapIntersectionWW.pos;
            this.addWaySegment(mapWaySegment);
            this.addWaySegment(mapWaySegment2);
            ForceNodeOnLine forceNodeOnLine = new ForceNodeOnLine(mapWaySegment, vectorXZ);
            ForceNodeOnLine forceNodeOnLine2 = new ForceNodeOnLine(mapWaySegment2, vectorXZ);
            this.handleVerticalDistance(mapWaySegment, mapWaySegment2, vectorXZ, forceNodeOnLine, forceNodeOnLine2);
            this.forceNodes.add(forceNodeOnLine);
            this.forceNodes.add(forceNodeOnLine2);
            this.lineMap.get(mapWaySegment).add(forceNodeOnLine);
            this.lineMap.get(mapWaySegment2).add(forceNodeOnLine2);
        }

        private final void addOverlapWA(MapOverlapWA mapOverlapWA) {
            block4: {
                MapArea mapArea;
                MapWaySegment mapWaySegment;
                block3: {
                    if (this.knownOverlaps.contains(mapOverlapWA)) {
                        return;
                    }
                    this.knownOverlaps.add(mapOverlapWA);
                    mapWaySegment = (MapWaySegment)mapOverlapWA.e1;
                    mapArea = (MapArea)mapOverlapWA.e2;
                    this.addWaySegment(mapWaySegment);
                    this.addArea(mapArea);
                    if (mapOverlapWA.type != MapOverlapType.INTERSECT) break block3;
                    for (VectorXZ vectorXZ : mapOverlapWA.getIntersectionPositions()) {
                        ForceNodeOnLine forceNodeOnLine = new ForceNodeOnLine(mapWaySegment, vectorXZ);
                        ForceNodeOnArea forceNodeOnArea = new ForceNodeOnArea(mapArea, vectorXZ);
                        this.handleVerticalDistance(mapWaySegment, mapArea, vectorXZ, forceNodeOnLine, forceNodeOnArea);
                        this.forceNodes.add(forceNodeOnLine);
                        this.forceNodes.add(forceNodeOnArea);
                        this.lineMap.get(mapWaySegment).add(forceNodeOnLine);
                    }
                    break block4;
                }
                if (mapOverlapWA.type != MapOverlapType.CONTAIN) break block4;
                for (MapNode mapNode : mapWaySegment.getStartEndNodes()) {
                    ForceNode forceNode = this.nodeMap.get(mapNode);
                    ForceNodeOnArea forceNodeOnArea = new ForceNodeOnArea(mapArea, mapNode.getPos());
                    this.handleVerticalDistance(mapWaySegment, mapArea, mapNode.getPos(), forceNode, forceNodeOnArea);
                    this.forceNodes.add(forceNode);
                    this.forceNodes.add(forceNodeOnArea);
                    this.lineMap.get(mapWaySegment).add(forceNode);
                }
            }
        }

        private final void addOverlapAA(MapOverlapAA mapOverlapAA) {
        }

        protected abstract void handleConstantElevation(ForceNode var1, Float var2, boolean var3);

        protected abstract void handleSameElevation(ForceNode var1, ForceNode var2);

        protected abstract void handleVerticalMinDistance(ForceNode var1, ForceNode var2, double var3);

        private void handleVerticalDistance(MapElement mapElement, MapElement mapElement2, VectorXZ vectorXZ, ForceNode forceNode, ForceNode forceNode2) {
            if (this.higherThan(mapElement, mapElement2)) {
                double d = this.getMinVerticalDistance(mapElement, mapElement2, vectorXZ);
                this.handleVerticalMinDistance(forceNode2, forceNode, d);
            } else if (this.higherThan(mapElement2, mapElement)) {
                double d = this.getMinVerticalDistance(mapElement2, mapElement, vectorXZ);
                this.handleVerticalMinDistance(forceNode, forceNode2, d);
            } else {
                this.handleSameElevation(forceNode, forceNode2);
            }
        }

        private boolean higherThan(MapElement mapElement, MapElement mapElement2) {
            GroundState groundState;
            GroundState groundState2 = mapElement.getPrimaryRepresentation().getGroundState();
            if (groundState2 == (groundState = mapElement2.getPrimaryRepresentation().getGroundState())) {
                return mapElement.getLayer() > mapElement2.getLayer();
            }
            return groundState2.isHigherThan(groundState);
        }

        private double getMinVerticalDistance(MapElement mapElement, MapElement mapElement2, VectorXZ vectorXZ) {
            double d = 0.0;
            for (WorldObject worldObject : mapElement.getRepresentations()) {
                if (!(worldObject.getClearingBelow(vectorXZ) > d)) continue;
                d = worldObject.getClearingBelow(vectorXZ);
            }
            double d2 = 0.0;
            for (WorldObject worldObject : mapElement2.getRepresentations()) {
                if (!(worldObject.getClearingAbove(vectorXZ) > d2)) continue;
                d2 = worldObject.getClearingAbove(vectorXZ);
            }
            return d + d2;
        }

        @Override
        public final void writeResult() {
            for (ForceNode forceNode : this.forceNodes) {
                forceNode.writeResult();
            }
        }

        public final class ForceNodeOnTerrainPoint
        extends ForceNode {
            private final TerrainPoint point;

            public ForceNodeOnTerrainPoint(TerrainPoint terrainPoint) {
                this.point = terrainPoint;
                if (terrainPoint.getEle() != null) {
                    this.currentEle = terrainPoint.getEle();
                }
            }

            @Override
            public VectorXZ getPos() {
                return this.point.getPos();
            }

            @Override
            public void writeResult() {
                this.point.setEle(this.currentEle.floatValue());
            }
        }

        public final class ForceNodeOnArea
        extends ForceNode {
            private final MapArea area;
            private final VectorXZ pos;

            public ForceNodeOnArea(MapArea mapArea, VectorXZ vectorXZ) {
                this.area = mapArea;
                this.pos = vectorXZ;
            }

            @Override
            public VectorXZ getPos() {
                return this.pos;
            }

            @Override
            public void writeResult() {
                this.area.getElevationProfile().addPointWithEle(this.pos.xyz(this.currentEle.floatValue()));
            }
        }

        public final class ForceNodeOnLine
        extends ForceNode {
            private final MapWaySegment line;
            private final VectorXZ pos;

            public ForceNodeOnLine(MapWaySegment mapWaySegment, VectorXZ vectorXZ) {
                this.line = mapWaySegment;
                this.pos = vectorXZ;
                ForceNodeOnNode forceNodeOnNode = AbstractElevationDeterminationScenario.this.nodeMap.get(mapWaySegment.getStartNode());
                ForceNodeOnNode forceNodeOnNode2 = AbstractElevationDeterminationScenario.this.nodeMap.get(mapWaySegment.getEndNode());
                if (forceNodeOnNode.getCurrentEle() != null && forceNodeOnNode2.getCurrentEle() != null) {
                    this.setCurrentEle(GeometryUtil.interpolateElevation((VectorXZ)vectorXZ, (VectorXYZ)forceNodeOnNode.getCurrentXYZ(), (VectorXYZ)forceNodeOnNode2.getCurrentXYZ()).y);
                }
            }

            @Override
            public VectorXZ getPos() {
                return this.pos;
            }

            @Override
            public void writeResult() {
                this.line.getElevationProfile().addPointWithEle(this.pos.xyz(this.currentEle.floatValue()));
            }
        }

        public final class ForceNodeOnNode
        extends ForceNode {
            private final MapNode node;

            public ForceNodeOnNode(MapNode mapNode) {
                this.node = mapNode;
                Float f = null;
                if (mapNode.getTags().containsKey("ele")) {
                    f = ValueStringParser.parseOsmDecimal(mapNode.getTags().getValue("ele"), true);
                }
                if (f == null) {
                    for (MapSegment mapSegment : mapNode.getConnectedSegments()) {
                        TagGroup tagGroup = mapSegment instanceof MapWaySegment ? ((MapWaySegment)mapSegment).getTags() : ((MapAreaSegment)mapSegment).getArea().getTags();
                        if (!tagGroup.containsKey("ele")) continue;
                        f = ValueStringParser.parseOsmDecimal(tagGroup.getValue("ele"), true);
                    }
                }
                if (f != null) {
                    this.setCurrentEle(f.floatValue());
                }
            }

            @Override
            public VectorXZ getPos() {
                return this.node.getPos();
            }

            @Override
            public void writeResult() {
                VectorXZ vectorXZ;
                ElevationProfile elevationProfile;
                this.node.getElevationProfile().setEle(this.currentEle.floatValue());
                for (MapWaySegment mapElement : this.node.getInboundLines()) {
                    if (mapElement.getPrimaryRepresentation() == null) continue;
                    elevationProfile = mapElement.getElevationProfile();
                    vectorXZ = mapElement.getPrimaryRepresentation().getEndPosition();
                    ((WaySegmentElevationProfile)elevationProfile).addPointWithEle(vectorXZ.xyz(this.currentEle.floatValue()));
                }
                for (MapWaySegment mapWaySegment : this.node.getOutboundLines()) {
                    if (mapWaySegment.getPrimaryRepresentation() == null) continue;
                    elevationProfile = mapWaySegment.getElevationProfile();
                    vectorXZ = mapWaySegment.getPrimaryRepresentation().getStartPosition();
                    ((WaySegmentElevationProfile)elevationProfile).addPointWithEle(vectorXZ.xyz(this.currentEle.floatValue()));
                }
                for (MapArea mapArea : this.node.getAdjacentAreas()) {
                    if (mapArea.getPrimaryRepresentation() == null) continue;
                    elevationProfile = mapArea.getElevationProfile();
                    ((AreaElevationProfile)elevationProfile).addPointWithEle(this.node.getPos().xyz(this.currentEle.floatValue()));
                }
            }
        }

        protected static abstract class ForceNode
        implements IntersectionTestObject {
            protected Float currentEle = null;

            protected ForceNode() {
            }

            public abstract VectorXZ getPos();

            public Float getCurrentEle() {
                return this.currentEle;
            }

            public VectorXYZ getCurrentXYZ() {
                return this.getPos().xyz(this.getCurrentEle().floatValue());
            }

            public void changeCurrentEle(double d) {
                this.currentEle = Float.valueOf(this.currentEle.floatValue() + (float)d);
            }

            protected void setCurrentEle(double d) {
                this.currentEle = Float.valueOf((float)d);
            }

            @Override
            public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
                return new AxisAlignedBoundingBoxXZ(this.getPos().x, this.getPos().z, this.getPos().x, this.getPos().z);
            }

            public abstract void writeResult();
        }
    }

    protected static interface ElevationDeterminationScenario {
        public void addElement(MapElement var1);

        public void addOverlap(MapOverlap<?, ?> var1);

        public void addTerrainPoint(TerrainPoint var1);

        public void calculate();

        public void writeResult();
    }
}

