/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.creation;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainElevationCell;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.creation.AdvancedAbstractElevationCalculator;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionGrid;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.util.MinMaxUtil;

public class ForceElevationCalculator
extends AdvancedAbstractElevationCalculator {
    public static final int CALCULATION_STEPS = 100;

    @Override
    protected AdvancedAbstractElevationCalculator.ElevationDeterminationScenario createScenario(CellularTerrainElevation cellularTerrainElevation) {
        return new ForceElevationDeterminationScenario(cellularTerrainElevation);
    }

    protected static class ForceElevationDeterminationScenario
    extends AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario {
        protected final CellularTerrainElevation eleData;
        protected final Collection<Force> forces = new ArrayList<Force>();

        public ForceElevationDeterminationScenario(CellularTerrainElevation cellularTerrainElevation) {
            this.eleData = cellularTerrainElevation;
        }

        @Override
        protected void handleConstantElevation(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, Float f, boolean bl) {
            this.forces.add(new NodeElevationForce(forceNode, f.floatValue(), bl));
        }

        @Override
        protected void handleVerticalMinDistance(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2, double d) {
            this.forces.add(new VerticalDistanceForce(forceNode, forceNode2, d));
        }

        @Override
        protected void handleSameElevation(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
            this.forces.add(new SameEleForce(forceNode, forceNode2));
        }

        @Override
        public void calculate() {
            this.addConnectionForces();
            this.addNeighborshipForces();
            this.initializeElevations();
            for (int i = 0; i < 100; ++i) {
                float f = this.forceScaleForStep(i);
                this.calculateStep(f);
            }
        }

        private void addConnectionForces() {
            for (final MapWaySegment mapWaySegment : this.lineMap.keySet()) {
                ArrayList arrayList = new ArrayList(this.lineMap.get(mapWaySegment));
                Collections.sort(arrayList, new Comparator<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>(){
                    final VectorXZ start;
                    {
                        this.start = mapWaySegment.getStartNode().getPos();
                    }

                    @Override
                    public int compare(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
                        return Double.compare(VectorXZ.distanceSquared(forceNode.getPos(), this.start), VectorXZ.distanceSquared(forceNode2.getPos(), this.start));
                    }
                });
                Boolean bl = null;
                Float f = null;
                TagGroup tagGroup = mapWaySegment.getOsmWay().tags;
                if (tagGroup.containsKey("incline")) {
                    String string = tagGroup.getValue("incline");
                    if ("up".equals(string)) {
                        bl = true;
                    } else if ("down".equals(string)) {
                        bl = false;
                    } else {
                        try {
                            Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)?)\\s*%");
                            Matcher matcher = pattern.matcher(string);
                            if (matcher.matches()) {
                                f = Float.valueOf(Float.parseFloat(matcher.group(1)));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                int n = 0;
                while (n + 1 < arrayList.size()) {
                    if (bl != null) {
                        this.forces.add(new DirectionConnectionForce((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n), (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n + 1), bl));
                    } else if (f != null) {
                        this.forces.add(new InclineConnectionForce((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n), (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n + 1), f.floatValue()));
                    } else {
                        this.forces.add(new UnknownInclineConnectionForce((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n), (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)arrayList.get(n + 1)));
                    }
                    ++n;
                }
            }
        }

        private void addNeighborshipForces() {
            HashSet<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode> hashSet;
            IntersectionGrid intersectionGrid = new IntersectionGrid(new AxisAlignedBoundingBoxXZ(this.eleData.getBoundaryPolygonXZ().getVertices()).pad(20.0), 50, 50);
            for (TerrainElevationCell object : this.eleData.getCells()) {
                intersectionGrid.insert(object);
            }
            for (MapWaySegment mapWaySegment : this.lineMap.keySet()) {
                if (mapWaySegment.getPrimaryRepresentation() == null || mapWaySegment.getPrimaryRepresentation().getGroundState() != GroundState.ON) continue;
                for (Object object2 : this.lineMap.get(mapWaySegment)) {
                    intersectionGrid.insert((IntersectionTestObject)object2);
                }
            }
            for (MapArea mapArea : this.areaMap.keySet()) {
                if (mapArea.getPrimaryRepresentation() == null || mapArea.getPrimaryRepresentation().getGroundState() != GroundState.ON) continue;
                for (Object object2 : this.areaMap.get(mapArea)) {
                    intersectionGrid.insert((IntersectionTestObject)object2);
                }
            }
            for (MapNode mapNode : this.nodeMap.keySet()) {
                if (mapNode.getPrimaryRepresentation() == null || mapNode.getPrimaryRepresentation().getGroundState() != GroundState.ON) continue;
                hashSet = (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.nodeMap.get(mapNode);
                intersectionGrid.insert((IntersectionTestObject)((Object)hashSet));
            }
            for (TerrainElevationCell terrainElevationCell : this.eleData.getCells()) {
                Object object;
                Object object2;
                this.forces.add(new NeighborshipForce((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.terrainPointMap.get(terrainElevationCell.getTopLeft()), (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.terrainPointMap.get(terrainElevationCell.getBottomLeft())));
                this.forces.add(new NeighborshipForce((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.terrainPointMap.get(terrainElevationCell.getTopLeft()), (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.terrainPointMap.get(terrainElevationCell.getTopRight())));
                hashSet = new HashSet<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>();
                object2 = Iterables.concat(intersectionGrid.cellsFor(terrainElevationCell));
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    IntersectionTestObject intersectionTestObject = (IntersectionTestObject)iterator.next();
                    if (!(intersectionTestObject instanceof AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)) continue;
                    object = (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)intersectionTestObject;
                    if (!terrainElevationCell.getPolygonXZ().contains(((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object).getPos())) continue;
                    hashSet.add((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object);
                }
                for (final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode : hashSet) {
                    object = MinMaxUtil.min(terrainElevationCell.getTerrainPoints(), new Function<TerrainPoint, Double>(){

                        @Override
                        public Double apply(TerrainPoint terrainPoint) {
                            return VectorXZ.distance(forceNode.getPos(), terrainPoint.getPos());
                        }
                    });
                    this.forces.add(new NeighborshipForce(forceNode, (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)this.terrainPointMap.get(object)));
                }
            }
        }

        private void initializeElevations() {
            HashMultimap<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode> hashMultimap = HashMultimap.create(this.forceNodes.size(), 6);
            for (Force object : this.forces) {
                if (!(object instanceof ConnectionForce)) continue;
                Object object2 = (ConnectionForce)object;
                hashMultimap.put(((ConnectionForce)object2).node1, ((ConnectionForce)object2).node2);
                hashMultimap.put(((ConnectionForce)object2).node2, ((ConnectionForce)object2).node1);
            }
            HashSet<Iterator<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>> hashSet = new HashSet();
            for (Object object2 : this.forceNodes) {
                if (((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object2).getCurrentEle() == null) continue;
                hashSet.add((Iterator<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>)object2);
            }
            while (!hashSet.isEmpty()) {
                ArrayListMultimap<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode, Float> arrayListMultimap = ArrayListMultimap.create();
                for (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode : hashSet) {
                    for (Object object : hashMultimap.get(forceNode)) {
                        if (((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object).getCurrentEle() != null) continue;
                        arrayListMultimap.put((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object, forceNode.getCurrentEle());
                    }
                }
                hashSet = new HashSet<Iterator<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>>();
                for (AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode : arrayListMultimap.keys()) {
                    Object object;
                    float f = 0.0f;
                    object = arrayListMultimap.get(forceNode).iterator();
                    while (object.hasNext()) {
                        float f2 = ((Float)object.next()).floatValue();
                        f += f2;
                    }
                    forceNode.setCurrentEle(f / (float)arrayListMultimap.get(forceNode).size());
                    hashSet.add((Iterator<AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode>)((Object)forceNode));
                }
            }
            for (Object object2 : this.forceNodes) {
                if (((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object2).getCurrentEle() != null) continue;
                ((AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode)object2).setCurrentEle(0.0);
            }
        }

        private float forceScaleForStep(int n) {
            float f = 0.00990099f;
            return 1.0f - (float)n * f;
        }

        private void calculateStep(float f) {
            for (Force force : this.forces) {
                force.prepare(f);
            }
            for (Force force : this.forces) {
                force.apply();
            }
        }

        protected static final class NeighborshipForce
        extends ConnectionForce {
            final float distanceFactor;

            public NeighborshipForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
                super(forceNode, forceNode2);
                float f = (float)forceNode.getPos().subtract(forceNode2.getPos()).length();
                this.distanceFactor = f <= 1.0f ? 1.0f : 1.0f / f;
            }

            @Override
            public void prepare(float f) {
                float f2 = Math.abs(this.node1.getCurrentEle().floatValue() - this.node2.getCurrentEle().floatValue());
                this.effect = Float.valueOf(f2 * this.distanceFactor * f);
                this.effect = Float.valueOf(this.effect.floatValue() * 0.4f);
                if (this.node1.getCurrentEle().floatValue() > this.node2.getCurrentEle().floatValue()) {
                    this.effect = Float.valueOf(-this.effect.floatValue());
                }
            }
        }

        protected static final class VerticalDistanceForce
        implements Force {
            private final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode lowerNode;
            private final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode upperNode;
            private final double minDistance;
            private Double effect = null;

            public VerticalDistanceForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2, double d) {
                this.lowerNode = forceNode;
                this.upperNode = forceNode2;
                this.minDistance = d;
            }

            @Override
            public void prepare(float f) {
                float f2 = this.upperNode.getCurrentEle().floatValue() - this.lowerNode.getCurrentEle().floatValue();
                if ((double)f2 < this.minDistance) {
                    this.effect = this.minDistance - (double)f2;
                    this.effect = this.effect * (double)f;
                } else {
                    this.effect = 0.0;
                }
            }

            @Override
            public void apply() {
                this.lowerNode.changeCurrentEle(-this.effect.doubleValue() / 2.0);
                this.upperNode.changeCurrentEle(this.effect / 2.0);
                this.effect = null;
            }
        }

        protected static final class NodeElevationForce
        implements Force {
            private final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode node;
            private final float ele;
            private final boolean tagged;
            private Float effect = null;

            public NodeElevationForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, float f, boolean bl) {
                this.node = forceNode;
                this.ele = f;
                this.tagged = bl;
            }

            @Override
            public void prepare(float f) {
                this.effect = Float.valueOf(this.ele - this.node.getCurrentEle().floatValue());
                this.effect = Float.valueOf(this.effect.floatValue() * f);
                if (!this.tagged) {
                    this.effect = Float.valueOf(this.effect.floatValue() * 0.3f);
                }
            }

            @Override
            public void apply() {
                this.node.changeCurrentEle(this.effect.floatValue());
                this.effect = null;
            }
        }

        protected static final class AngleForce
        implements Force {
            protected final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode node;
            protected final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode neighbor1;
            protected final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode neighbor2;
            protected Double effect = null;

            public AngleForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode3) {
                this.node = forceNode;
                this.neighbor1 = forceNode2;
                this.neighbor2 = forceNode3;
            }

            @Override
            public void prepare(float f) {
                double d = GeometryUtil.interpolateElevation((VectorXZ)this.node.getPos(), (VectorXYZ)this.neighbor1.getCurrentXYZ(), (VectorXYZ)this.neighbor2.getCurrentXYZ()).y;
                this.effect = d - (double)this.node.getCurrentEle().floatValue();
                this.effect = this.effect * (double)f;
            }

            @Override
            public void apply() {
                this.node.changeCurrentEle(this.effect);
                this.effect = null;
            }
        }

        protected static final class SameEleForce
        extends ConnectionForce {
            public SameEleForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
                super(forceNode, forceNode2);
            }

            @Override
            public void prepare(float f) {
                this.effect = Float.valueOf(Math.abs(this.node1.getCurrentEle().floatValue() - this.node2.getCurrentEle().floatValue()));
                this.effect = Float.valueOf(this.effect.floatValue() * f);
                if (this.node1.getCurrentEle().floatValue() > this.node2.getCurrentEle().floatValue()) {
                    this.effect = Float.valueOf(-this.effect.floatValue());
                }
            }
        }

        protected static final class InclineConnectionForce
        extends ConnectionForce {
            private final float incline;

            public InclineConnectionForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2, float f) {
                super(forceNode, forceNode2);
                this.incline = f;
            }

            @Override
            public void prepare(float f) {
                this.effect = Float.valueOf(0.0f);
            }
        }

        protected static final class DirectionConnectionForce
        extends ConnectionForce {
            private static final float DESIRED_INCLINE = 0.05f;
            private final boolean up;
            private float eleDiffLimit;

            public DirectionConnectionForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2, boolean bl) {
                super(forceNode, forceNode2);
                this.up = bl;
                double d = forceNode2.getPos().subtract(forceNode.getPos()).length();
                this.eleDiffLimit = (float)d * 0.05f;
            }

            @Override
            public void prepare(float f) {
                float f2 = this.node2.getCurrentEle().floatValue() - this.node1.getCurrentEle().floatValue();
                this.effect = Float.valueOf(0.0f);
                if (this.up && f2 < this.eleDiffLimit) {
                    this.effect = Float.valueOf(f2 - this.eleDiffLimit);
                } else if (!this.up && f2 > -this.eleDiffLimit) {
                    this.effect = Float.valueOf(f2 + this.eleDiffLimit);
                }
                this.effect = Float.valueOf(this.effect.floatValue() * f);
            }
        }

        protected static final class UnknownInclineConnectionForce
        extends ConnectionForce {
            private static final float baseStrengthFactor = 0.1f;

            public UnknownInclineConnectionForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
                super(forceNode, forceNode2);
            }

            @Override
            public void prepare(float f) {
                this.effect = Float.valueOf(Math.abs(this.node1.getCurrentEle().floatValue() - this.node2.getCurrentEle().floatValue()));
                this.effect = Float.valueOf(this.effect.floatValue() * 0.1f);
                this.effect = Float.valueOf(this.effect.floatValue() * f);
                if (this.node1.getCurrentEle().floatValue() > this.node2.getCurrentEle().floatValue()) {
                    this.effect = Float.valueOf(-this.effect.floatValue());
                }
            }
        }

        protected static abstract class ConnectionForce
        implements Force {
            protected final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode node1;
            protected final AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode node2;
            protected Float effect = null;

            public ConnectionForce(AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode, AdvancedAbstractElevationCalculator.AbstractElevationDeterminationScenario.ForceNode forceNode2) {
                this.node1 = forceNode;
                this.node2 = forceNode2;
            }

            @Override
            public void apply() {
                if (this.effect != null) {
                    this.node1.changeCurrentEle(this.effect.floatValue() / 2.0f);
                    this.node2.changeCurrentEle(-this.effect.floatValue() / 2.0f);
                    this.effect = null;
                }
            }
        }

        protected static interface Force {
            public void prepare(float var1);

            public void apply();
        }
    }
}

