/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.creation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.map_elevation.data.AreaElevationProfile;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;

public abstract class TagElevationCalculator
implements ElevationCalculator {
    Double terrainElevation;

    public TagElevationCalculator(Double d) {
        this.terrainElevation = d;
    }

    public TagElevationCalculator() {
        this(0.0);
    }

    @Override
    public void calculateElevations(MapData mapData, CellularTerrainElevation cellularTerrainElevation) {
        Object object;
        Object object2;
        for (MapNode object4 : mapData.getMapNodes()) {
            object2 = this.getEleForTags(object4.getTags());
            if (object2 == null) {
                for (MapSegment mapSegment : object4.getConnectedSegments()) {
                    object = mapSegment instanceof MapWaySegment ? ((MapWaySegment)mapSegment).getTags() : ((MapAreaSegment)mapSegment).getArea().getTags();
                    object2 = this.getEleForTags((TagGroup)object);
                }
            }
            if (object2 == null) continue;
            NodeElevationProfile nodeElevationProfile = new NodeElevationProfile(object4);
            nodeElevationProfile.setEle((Double)object2);
            object4.setElevationProfile(nodeElevationProfile);
        }
        for (MapNode mapNode : mapData.getMapNodes()) {
            if (mapNode.getElevationProfile() != null) continue;
            object2 = new ArrayList();
            for (MapSegment mapSegment : mapNode.getConnectedSegments()) {
                object = TagElevationCalculator.findConnectionToNodeWithEle(mapNode, mapSegment);
                if (object == null) continue;
                object2.add(object);
            }
            Collections.sort(object2, new Comparator<Connection>(){

                @Override
                public int compare(Connection connection, Connection connection2) {
                    return Double.compare(connection.getLength(), connection2.getLength());
                }
            });
            double d = 0.0;
            if (object2.size() < 2) {
                System.err.println("node without ele information: " + mapNode);
            } else {
                object = (Connection)object2.get(0);
                Object object3 = (Connection)object2.get(1);
                double d2 = ((Connection)object).endNode.getElevationProfile().getEle();
                double d3 = ((Connection)object3).endNode.getElevationProfile().getEle();
                d = (d2 * ((Connection)object3).getLength() + d3 * ((Connection)object).getLength()) / (((Connection)object).getLength() + ((Connection)object3).getLength());
            }
            object = new NodeElevationProfile(mapNode);
            ((NodeElevationProfile)object).setEle(d);
            mapNode.setElevationProfile((NodeElevationProfile)object);
        }
        for (MapWaySegment mapWaySegment : mapData.getMapWaySegments()) {
            if (mapWaySegment.getPrimaryRepresentation() == null) continue;
            object2 = new WaySegmentElevationProfile(mapWaySegment);
            ((WaySegmentElevationProfile)object2).addPointWithEle(mapWaySegment.getStartNode().getElevationProfile().getPointWithEle());
            ((WaySegmentElevationProfile)object2).addPointWithEle(mapWaySegment.getEndNode().getElevationProfile().getPointWithEle());
            mapWaySegment.setElevationProfile((WaySegmentElevationProfile)object2);
        }
        for (MapArea mapArea : mapData.getMapAreas()) {
            if (mapArea.getPrimaryRepresentation() == null) continue;
            object2 = new AreaElevationProfile(mapArea);
            for (MapNode mapNode : mapArea.getBoundaryNodes()) {
                ((AreaElevationProfile)object2).addPointWithEle(mapNode.getElevationProfile().getPointWithEle());
            }
            for (List list : mapArea.getHoles()) {
                for (Object object3 : list) {
                    ((AreaElevationProfile)object2).addPointWithEle(((MapNode)object3).getElevationProfile().getPointWithEle());
                }
            }
            mapArea.setElevationProfile((AreaElevationProfile)object2);
        }
        for (TerrainPoint terrainPoint : cellularTerrainElevation.getTerrainPoints()) {
            terrainPoint.setEle((float)this.terrainElevation.doubleValue());
        }
    }

    private static final Connection findConnectionToNodeWithEle(MapNode mapNode, MapSegment mapSegment) {
        ArrayList<MapSegment> arrayList = new ArrayList<MapSegment>();
        MapNode mapNode2 = mapNode;
        MapSegment mapSegment2 = mapSegment;
        block0: while (true) {
            MapSegment mapSegment3;
            arrayList.add(mapSegment2);
            mapNode2 = mapSegment2.getOtherNode(mapNode2);
            if (mapNode2.getElevationProfile() != null) {
                return new Connection(arrayList, mapNode2);
            }
            if (mapNode2 == mapNode) {
                return null;
            }
            if (mapNode2.getConnectedSegments().size() > 2) {
                return null;
            }
            Iterator<MapSegment> iterator = mapNode2.getConnectedSegments().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while ((mapSegment3 = iterator.next()) == mapSegment2);
            mapSegment2 = mapSegment3;
        }
    }

    protected abstract Double getEleForTags(TagGroup var1);

    private static class Connection {
        public final List<MapSegment> segmentSequence;
        public final MapNode endNode;

        public Connection(List<MapSegment> list, MapNode mapNode) {
            this.segmentSequence = list;
            this.endNode = mapNode;
        }

        public double getLength() {
            double d = 0.0;
            for (MapSegment mapSegment : this.segmentSequence) {
                d += mapSegment.getLineSegment().getLength();
            }
            return d;
        }
    }
}

