/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.creation;

import java.util.List;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.map_elevation.data.AreaElevationProfile;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;

public class ZeroElevationCalculator
implements ElevationCalculator {
    @Override
    public void calculateElevations(MapData mapData, CellularTerrainElevation cellularTerrainElevation) {
        ElevationProfile elevationProfile;
        for (MapNode object : mapData.getMapNodes()) {
            elevationProfile = new NodeElevationProfile(object);
            ((NodeElevationProfile)elevationProfile).setEle(0.0);
            object.setElevationProfile((NodeElevationProfile)elevationProfile);
        }
        for (MapWaySegment mapWaySegment : mapData.getMapWaySegments()) {
            if (mapWaySegment.getPrimaryRepresentation() == null) continue;
            elevationProfile = new WaySegmentElevationProfile(mapWaySegment);
            ((WaySegmentElevationProfile)elevationProfile).addPointWithEle(mapWaySegment.getStartNode().getElevationProfile().getPointWithEle());
            ((WaySegmentElevationProfile)elevationProfile).addPointWithEle(mapWaySegment.getEndNode().getElevationProfile().getPointWithEle());
            mapWaySegment.setElevationProfile((WaySegmentElevationProfile)elevationProfile);
        }
        for (MapArea mapArea : mapData.getMapAreas()) {
            if (mapArea.getPrimaryRepresentation() == null) continue;
            elevationProfile = new AreaElevationProfile(mapArea);
            for (MapNode mapNode : mapArea.getBoundaryNodes()) {
                ((AreaElevationProfile)elevationProfile).addPointWithEle(mapNode.getElevationProfile().getPointWithEle());
            }
            for (List list : mapArea.getHoles()) {
                for (MapNode mapNode : list) {
                    ((AreaElevationProfile)elevationProfile).addPointWithEle(mapNode.getElevationProfile().getPointWithEle());
                }
            }
            mapArea.setElevationProfile((AreaElevationProfile)elevationProfile);
        }
        for (TerrainPoint terrainPoint : cellularTerrainElevation.getTerrainPoints()) {
            terrainPoint.setEle(0.0f);
        }
    }
}

