/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class AreaElevationProfile
extends ElevationProfile {
    private final MapArea area;
    private Collection<VectorXYZ> pointsWithEle = null;
    Collection<TriangleXYZ> triangulation = null;

    public AreaElevationProfile(MapArea mapArea) {
        this.area = mapArea;
    }

    @Override
    protected MapElement getElement() {
        return this.area;
    }

    @Override
    public Collection<VectorXYZ> getPointsWithEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        if (this.pointsWithEle.size() < 2) {
            throw new IllegalStateException("an area must have at least two points with elevation");
        }
        return this.pointsWithEle;
    }

    @Override
    public double getEleAt(final VectorXZ vectorXZ) {
        VectorXYZ vectorXYZ = Collections.min(this.pointsWithEle, new Comparator<VectorXYZ>(){

            @Override
            public int compare(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2) {
                return Double.compare(vectorXYZ.xz().distanceTo(vectorXZ), vectorXYZ2.xz().distanceTo(vectorXZ));
            }
        });
        return vectorXYZ.y;
    }

    public void addPointWithEle(VectorXYZ vectorXYZ) {
        if (this.pointsWithEle == null) {
            this.pointsWithEle = new ArrayList<VectorXYZ>();
        }
        this.pointsWithEle.add(vectorXYZ);
    }

    @Override
    public double getMaxEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        double d = Double.MIN_VALUE;
        for (VectorXYZ vectorXYZ : this.pointsWithEle) {
            d = Math.max(d, vectorXYZ.y);
        }
        return d;
    }

    @Override
    public double getMinEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        double d = Double.MAX_VALUE;
        for (VectorXYZ vectorXYZ : this.pointsWithEle) {
            d = Math.min(d, vectorXYZ.y);
        }
        return d;
    }
}

