/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.data;

import java.util.Arrays;
import java.util.Collection;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class NodeElevationProfile
extends ElevationProfile {
    private final MapNode node;
    private VectorXYZ pointWithEle;

    public NodeElevationProfile(MapNode mapNode) {
        this.node = mapNode;
    }

    @Override
    protected MapElement getElement() {
        return this.node;
    }

    public VectorXYZ getPointWithEle() {
        if (this.pointWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        return this.pointWithEle;
    }

    @Override
    public Collection<VectorXYZ> getPointsWithEle() {
        return Arrays.asList(this.pointWithEle);
    }

    public double getEle() {
        if (this.pointWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        return this.pointWithEle.y;
    }

    @Override
    public double getEleAt(VectorXZ vectorXZ) {
        return this.getEle();
    }

    public void setEle(double d) {
        this.pointWithEle = this.node.getPos().xyz(d);
    }

    @Override
    public double getMaxEle() {
        if (this.pointWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        return this.pointWithEle.y;
    }

    @Override
    public double getMinEle() {
        if (this.pointWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        return this.pointWithEle.y;
    }
}

