/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.map_elevation.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class WaySegmentElevationProfile
extends ElevationProfile {
    private final MapWaySegment line;
    private List<VectorXYZ> pointsWithEle = null;

    public WaySegmentElevationProfile(MapWaySegment mapWaySegment) {
        this.line = mapWaySegment;
    }

    @Override
    protected MapElement getElement() {
        return this.line;
    }

    private void sortPointsWithEle() {
        Collections.sort(this.pointsWithEle, new Comparator<VectorXYZ>(){
            final VectorXZ startPos;
            {
                this.startPos = WaySegmentElevationProfile.this.line.getPrimaryRepresentation().getStartPosition();
            }

            @Override
            public int compare(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2) {
                return Double.compare(vectorXYZ.xz().subtract(this.startPos).lengthSquared(), vectorXYZ2.xz().subtract(this.startPos).lengthSquared());
            }
        });
    }

    public List<VectorXYZ> getPointsWithEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        if (this.pointsWithEle.size() < 2) {
            throw new IllegalStateException("a line must have at least two points with elevation");
        }
        return this.pointsWithEle;
    }

    @Override
    public double getEleAt(VectorXZ vectorXZ) {
        double d;
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        if (this.pointsWithEle.size() < 2) {
            throw new IllegalStateException("a line must have at least two points with elevation");
        }
        VectorXZ vectorXZ2 = this.line.getPrimaryRepresentation().getStartPosition();
        double d2 = vectorXZ.subtract(vectorXZ2).length();
        VectorXYZ vectorXYZ = null;
        VectorXYZ vectorXYZ2 = null;
        double d3 = 0.0;
        double d4 = 0.0;
        for (VectorXYZ vectorXYZ3 : this.pointsWithEle) {
            d = vectorXYZ3.xz().subtract(vectorXZ2).length();
            if (d < d2) {
                vectorXYZ = vectorXYZ3;
                d3 = d;
                continue;
            }
            if (d == d2) {
                return vectorXYZ3.y;
            }
            vectorXYZ2 = vectorXYZ3;
            d4 = d;
            break;
        }
        if (vectorXYZ == null) {
            return vectorXYZ2.y;
        }
        if (vectorXYZ2 == null) {
            return vectorXYZ.y;
        }
        double d5 = (d2 - d3) / (d4 - d3);
        d = vectorXYZ.y * (1.0 - d5) + vectorXYZ2.y * d5;
        return d;
    }

    public void addPointWithEle(VectorXYZ vectorXYZ) {
        if (this.pointsWithEle == null) {
            this.pointsWithEle = new ArrayList<VectorXYZ>();
        }
        this.pointsWithEle.add(vectorXYZ);
        this.sortPointsWithEle();
    }

    @Override
    public double getMaxEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        double d = Double.MIN_VALUE;
        for (VectorXYZ vectorXYZ : this.pointsWithEle) {
            d = Math.max(d, vectorXYZ.y);
        }
        return d;
    }

    @Override
    public double getMinEle() {
        if (this.pointsWithEle == null) {
            throw new IllegalStateException("elevations have not been calculated yet");
        }
        double d = Double.MAX_VALUE;
        for (VectorXYZ vectorXYZ : this.pointsWithEle) {
            d = Math.min(d, vectorXYZ.y);
        }
        return d;
    }
}

