/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import java.util.ArrayList;
import java.util.Collection;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;

public class AxisAlignedBoundingBoxXZ {
    public final double minX;
    public final double minZ;
    public final double maxX;
    public final double maxZ;
    private SimplePolygonXZ polygonXZ;

    public AxisAlignedBoundingBoxXZ(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.minZ = d2;
        this.maxX = d3;
        this.maxZ = d4;
    }

    public AxisAlignedBoundingBoxXZ(Collection<? extends Vector3D> collection) {
        assert (!collection.isEmpty());
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (Vector3D vector3D : collection) {
            d = Math.min(d, vector3D.getX());
            d2 = Math.min(d2, vector3D.getZ());
            d3 = Math.max(d3, vector3D.getX());
            d4 = Math.max(d4, vector3D.getZ());
        }
        this.minX = d;
        this.minZ = d2;
        this.maxX = d3;
        this.maxZ = d4;
    }

    public double sizeX() {
        return this.maxX - this.minX;
    }

    public double sizeZ() {
        return this.maxZ - this.minZ;
    }

    public VectorXZ center() {
        return new VectorXZ(this.minX + this.sizeX() / 2.0, this.minZ + this.sizeZ() / 2.0);
    }

    public SimplePolygonXZ polygonXZ() {
        if (this.polygonXZ == null) {
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(5);
            arrayList.add(new VectorXZ(this.minX, this.minZ));
            arrayList.add(new VectorXZ(this.maxX, this.minZ));
            arrayList.add(new VectorXZ(this.maxX, this.maxZ));
            arrayList.add(new VectorXZ(this.minX, this.maxZ));
            arrayList.add((VectorXZ)arrayList.get(0));
            this.polygonXZ = new SimplePolygonXZ(arrayList);
        }
        return this.polygonXZ;
    }

    public AxisAlignedBoundingBoxXZ pad(double d) {
        return new AxisAlignedBoundingBoxXZ(this.minX - d, this.minZ - d, this.maxX + d, this.maxZ + d);
    }

    public boolean contains(IntersectionTestObject intersectionTestObject) {
        return this.polygonXZ().contains(intersectionTestObject.getAxisAlignedBoundingBoxXZ().polygonXZ());
    }

    public boolean contains(VectorXZ vectorXZ) {
        return vectorXZ.x >= this.minX && vectorXZ.x <= this.maxX && vectorXZ.z >= this.minZ && vectorXZ.z <= this.maxZ;
    }

    public static final AxisAlignedBoundingBoxXZ union(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ2) {
        return new AxisAlignedBoundingBoxXZ(Math.min(axisAlignedBoundingBoxXZ.minX, axisAlignedBoundingBoxXZ2.minX), Math.min(axisAlignedBoundingBoxXZ.minZ, axisAlignedBoundingBoxXZ2.minZ), Math.max(axisAlignedBoundingBoxXZ.maxX, axisAlignedBoundingBoxXZ2.maxX), Math.max(axisAlignedBoundingBoxXZ.maxZ, axisAlignedBoundingBoxXZ2.maxZ));
    }
}

