/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public final class GeometryUtil {
    private static final int MAX_FAILED_ATTEMPTS = 500;
    private static final double EPSILON = (double)1.0E-4f;

    private GeometryUtil() {
    }

    public static final List<TriangleXYZ> trianglesFromVertexList(List<? extends VectorXYZ> list) {
        if (list.size() % 3 != 0) {
            throw new IllegalArgumentException("vertex size must be multiple of 3");
        }
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size() / 3);
        for (int i = 0; i < list.size() / 3; ++i) {
            arrayList.add(new TriangleXYZ(list.get(i * 3), list.get(i * 3 + 1), list.get(i * 3 + 2)));
        }
        return arrayList;
    }

    public static final List<TriangleXYZ> trianglesFromTriangleStrip(List<? extends VectorXYZ> list) {
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size() - 2);
        int n = 0;
        while (n + 2 < list.size()) {
            if (n % 2 == 0) {
                arrayList.add(new TriangleXYZ(list.get(n), list.get(n + 1), list.get(n + 2)));
            } else {
                arrayList.add(new TriangleXYZ(list.get(n), list.get(n + 2), list.get(n + 1)));
            }
            ++n;
        }
        return arrayList;
    }

    public static final List<TriangleXYZ> trianglesFromTriangleFan(List<? extends VectorXYZ> list) {
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size() - 2);
        VectorXYZ vectorXYZ = list.get(0);
        int n = 0;
        while (n + 2 < list.size()) {
            arrayList.add(new TriangleXYZ(vectorXYZ, list.get(n + 1), list.get(n + 2)));
            ++n;
        }
        return arrayList;
    }

    public static final VectorXZ getLineIntersection(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3, VectorXZ vectorXZ4) {
        double d = vectorXZ2.z * vectorXZ4.x - vectorXZ2.x * vectorXZ4.z;
        if (GeometryUtil.approxZero(d)) {
            return null;
        }
        d = 1.0 / d;
        double d2 = vectorXZ3.x - vectorXZ.x;
        double d3 = vectorXZ3.z - vectorXZ.z;
        double d4 = (d3 * vectorXZ4.x - d2 * vectorXZ4.z) * d;
        return new VectorXZ(vectorXZ.x + d4 * vectorXZ2.x, vectorXZ.z + d4 * vectorXZ2.z);
    }

    public static final VectorXZ getLineSegmentIntersection(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3, VectorXZ vectorXZ4) {
        double d = vectorXZ2.z - vectorXZ.z;
        double d2 = vectorXZ4.x - vectorXZ3.x;
        double d3 = vectorXZ2.x - vectorXZ.x;
        double d4 = vectorXZ4.z - vectorXZ3.z;
        double d5 = d * d2 - d3 * d4;
        if (GeometryUtil.approxZero(d5)) {
            return null;
        }
        double d6 = vectorXZ3.z - vectorXZ.z;
        double d7 = vectorXZ3.x - vectorXZ.x;
        double d8 = (d6 * d2 - d7 * d4) * (d5 = 1.0 / d5);
        if (d8 < 0.0 || d8 > 1.0) {
            return null;
        }
        double d9 = (d6 * d3 - d7 * d) * d5;
        if (d9 < 0.0 || d9 > 1.0) {
            return null;
        }
        return new VectorXZ(vectorXZ.x + d8 * d3, vectorXZ.z + d8 * d);
    }

    public static final VectorXZ getTrueLineSegmentIntersection(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3, VectorXZ vectorXZ4) {
        if (vectorXZ.equals(vectorXZ3) || vectorXZ.equals(vectorXZ4) || vectorXZ2.equals(vectorXZ3) || vectorXZ2.equals(vectorXZ4)) {
            return null;
        }
        return GeometryUtil.getLineSegmentIntersection(vectorXZ, vectorXZ2, vectorXZ3, vectorXZ4);
    }

    public static final boolean isRightOf(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3) {
        return 0.0 > (vectorXZ.z - vectorXZ2.z) * (vectorXZ3.x - vectorXZ2.x) - (vectorXZ.x - vectorXZ2.x) * (vectorXZ3.z - vectorXZ2.z);
    }

    public static final boolean isBetween(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3) {
        double d = VectorXZ.distanceSquared(vectorXZ2, vectorXZ3);
        double d2 = VectorXZ.distanceSquared(vectorXZ, vectorXZ2);
        double d3 = VectorXZ.distanceSquared(vectorXZ, vectorXZ3);
        return d < d2 && d < d3;
    }

    public static final double distanceFromLineSegment(VectorXZ vectorXZ, LineSegmentXZ lineSegmentXZ) {
        LineSegment lineSegment = new LineSegment(lineSegmentXZ.p1.x, lineSegmentXZ.p1.z, lineSegmentXZ.p2.x, lineSegmentXZ.p2.z);
        return lineSegment.distance(new Coordinate(vectorXZ.x, vectorXZ.z));
    }

    public static final List<VectorXYZ> sequenceAbove(List<VectorXYZ> list, double d) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(list.size());
        VectorXYZ vectorXYZ = VectorXYZ.Y_UNIT.mult(d);
        for (VectorXYZ vectorXYZ2 : list) {
            arrayList.add(vectorXYZ2.add(vectorXYZ));
        }
        return arrayList;
    }

    public static VectorXZ interpolateBetween(VectorXZ vectorXZ, VectorXZ vectorXZ2, double d) {
        return new VectorXZ(vectorXZ.x * (1.0 - d) + vectorXZ2.x * d, vectorXZ.z * (1.0 - d) + vectorXZ2.z * d);
    }

    public static VectorXYZ interpolateBetween(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, double d) {
        return new VectorXYZ(vectorXYZ.x * (1.0 - d) + vectorXYZ2.x * d, vectorXYZ.y * (1.0 - d) + vectorXYZ2.y * d, vectorXYZ.z * (1.0 - d) + vectorXYZ2.z * d);
    }

    public static VectorXYZ interpolateElevation(VectorXZ vectorXZ, VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2) {
        double d = GeometryUtil.interpolateValue(vectorXZ, vectorXYZ.xz(), vectorXYZ.y, vectorXYZ2.xz(), vectorXYZ2.y);
        return vectorXZ.xyz(d);
    }

    public static double interpolateValue(VectorXZ vectorXZ, VectorXZ vectorXZ2, double d, VectorXZ vectorXZ3, double d2) {
        double d3 = VectorXZ.distance(vectorXZ2, vectorXZ) / (VectorXZ.distance(vectorXZ2, vectorXZ) + VectorXZ.distance(vectorXZ, vectorXZ3));
        return d * (1.0 - d3) + d2 * d3;
    }

    public static List<VectorXZ> equallyDistributePointsAlong(double d, boolean bl, VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        double d2 = vectorXZ.subtract(vectorXZ2).length();
        int n = (int)Math.round(d2 / d);
        if (n == 0) {
            return new ArrayList<VectorXZ>(0);
        }
        double d3 = d2 / (double)n;
        VectorXZ vectorXZ3 = vectorXZ2.subtract(vectorXZ).normalize().mult(d3);
        int n2 = bl ? n + 1 : n;
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(n2);
        VectorXZ vectorXZ4 = bl ? vectorXZ : vectorXZ.add(vectorXZ3.mult(0.5));
        arrayList.add(vectorXZ4);
        for (int i = 1; i < n2; ++i) {
            vectorXZ4 = vectorXZ4.add(vectorXZ3);
            arrayList.add(vectorXZ4);
        }
        return arrayList;
    }

    public static List<VectorXZ> equallyDistributePointsAlong(double d, boolean bl, List<VectorXZ> list) {
        double d2 = 0.0;
        int n = 0;
        while (n + 1 < list.size()) {
            d2 += list.get(n + 1).subtract(list.get(n)).length();
            ++n;
        }
        n = (int)Math.round(d2 / d);
        if (n == 0) {
            return Collections.emptyList();
        }
        double d3 = d2 / (double)n;
        int n2 = bl ? n + 1 : n;
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(n2);
        double d4 = bl ? 0.0 : d3 / 2.0;
        for (int i = 1; i < n2; ++i) {
            d4 += d3;
        }
        return arrayList;
    }

    public static PolygonXZ insertIntoPolygon(PolygonXZ polygonXZ, VectorXZ vectorXZ, double d) {
        LineSegmentXZ lineSegmentXZ = polygonXZ.getClosestSegment(vectorXZ);
        int n = 0;
        while (n + 1 <= polygonXZ.size()) {
            if (polygonXZ.getVertex(n).equals(lineSegmentXZ.p1) && polygonXZ.getVertexAfter(n).equals(lineSegmentXZ.p2)) {
                if (polygonXZ.getVertex(n).distanceTo(vectorXZ) <= d || polygonXZ.getVertexAfter(n).distanceTo(vectorXZ) <= d) {
                    return polygonXZ;
                }
                ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(polygonXZ.getVertexLoop());
                arrayList.add(n + 1, vectorXZ);
                return new PolygonXZ(arrayList);
            }
            ++n;
        }
        throw new IllegalArgumentException("segment " + lineSegmentXZ + " was not found in polygon " + polygonXZ);
    }

    public static List<VectorXZ> randomlyDistributePointsOn(PolygonWithHolesXZ polygonWithHolesXZ, double d, double d2) {
        int n = (int)(polygonWithHolesXZ.getArea() * d);
        List<VectorXZ> list = polygonWithHolesXZ.getOuter().getVertices();
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = new AxisAlignedBoundingBoxXZ(list);
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(n);
        int n2 = 0;
        while (arrayList.size() < n && n2 <= 500) {
            double d3;
            double d4 = axisAlignedBoundingBoxXZ.minX + (axisAlignedBoundingBoxXZ.maxX - axisAlignedBoundingBoxXZ.minX) * Math.random();
            VectorXZ vectorXZ = new VectorXZ(d4, d3 = axisAlignedBoundingBoxXZ.minZ + (axisAlignedBoundingBoxXZ.maxZ - axisAlignedBoundingBoxXZ.minZ) * Math.random());
            if (polygonWithHolesXZ.contains(vectorXZ)) {
                arrayList.add(vectorXZ);
                n2 = 0;
                continue;
            }
            ++n2;
        }
        return arrayList;
    }

    private static final boolean approxZero(double d) {
        return d <= (double)1.0E-4f && d >= (double)-1.0E-4f;
    }
}

