/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class JTSConversionUtil {
    public static final GeometryFactory GF = new GeometryFactory();

    public static final Coordinate vectorXZToJTSCoordinate(VectorXZ vectorXZ) {
        return new Coordinate(vectorXZ.x, vectorXZ.z);
    }

    public static final Coordinate vectorXYZToJTSCoordinate(VectorXYZ vectorXYZ) {
        return new Coordinate(vectorXYZ.x, vectorXYZ.z, vectorXYZ.y);
    }

    public static final VectorXZ vectorXZFromJTSCoordinate(Coordinate coordinate) {
        return new VectorXZ(coordinate.x, coordinate.y);
    }

    public static final VectorXYZ vectorXYZFromJTSCoordinate(Coordinate coordinate) {
        return new VectorXYZ(coordinate.x, coordinate.z, coordinate.y);
    }

    public static LineString lineSegmentXZToJTSLineString(LineSegmentXZ lineSegmentXZ) {
        Coordinate[] coordinateArray = new Coordinate[]{JTSConversionUtil.vectorXZToJTSCoordinate(lineSegmentXZ.p1), JTSConversionUtil.vectorXZToJTSCoordinate(lineSegmentXZ.p2)};
        return new LineString(new CoordinateArraySequence(coordinateArray), GF);
    }

    public static final Polygon polygonXZToJTSPolygon(SimplePolygonXZ simplePolygonXZ) {
        List<VectorXZ> list = simplePolygonXZ.getVertexLoop();
        Coordinate[] coordinateArray = new Coordinate[list.size()];
        for (int i = 0; i < coordinateArray.length; ++i) {
            VectorXZ vectorXZ = list.get(i);
            coordinateArray[i] = JTSConversionUtil.vectorXZToJTSCoordinate(vectorXZ);
        }
        return new Polygon(new LinearRing(new CoordinateArraySequence(coordinateArray), GF), null, GF);
    }

    public static final PolygonWithHolesXZ polygonXZFromJTSPolygon(Polygon polygon) {
        SimplePolygonXZ simplePolygonXZ = JTSConversionUtil.polygonXZFromLineString(polygon.getExteriorRing());
        List<SimplePolygonXZ> list = Collections.emptyList();
        if (polygon.getNumInteriorRing() > 0) {
            list = new ArrayList();
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                list.add(JTSConversionUtil.polygonXZFromLineString(polygon.getInteriorRingN(i)));
            }
        }
        return new PolygonWithHolesXZ(simplePolygonXZ, list);
    }

    private static final SimplePolygonXZ polygonXZFromLineString(LineString lineString) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(lineString.getNumPoints());
        for (Coordinate coordinate : lineString.getCoordinates()) {
            arrayList.add(JTSConversionUtil.vectorXZFromJTSCoordinate(coordinate));
        }
        return new SimplePolygonXZ(arrayList);
    }

    public static final Collection<PolygonWithHolesXZ> polygonsXZFromJTSGeometry(Geometry geometry) {
        ArrayList<PolygonWithHolesXZ> arrayList = new ArrayList<PolygonWithHolesXZ>(1);
        if (geometry instanceof Polygon) {
            if (geometry.getNumPoints() > 2) {
                arrayList.add(JTSConversionUtil.polygonXZFromJTSPolygon((Polygon)geometry));
            }
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                arrayList.addAll(JTSConversionUtil.polygonsXZFromJTSGeometry(geometryCollection.getGeometryN(i)));
            }
        } else {
            System.err.println("unhandled geometry type: " + geometry.getClass());
        }
        return arrayList;
    }
}

