/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXZ;

public class LineSegmentXZ {
    public final VectorXZ p1;
    public final VectorXZ p2;

    public LineSegmentXZ(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        this.p1 = vectorXZ;
        this.p2 = vectorXZ2;
    }

    public VectorXZ getCenter() {
        return GeometryUtil.interpolateBetween(this.p1, this.p2, 0.5);
    }

    public boolean intersects(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        return this.getIntersection(vectorXZ, vectorXZ2) != null;
    }

    public VectorXZ getIntersection(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        return GeometryUtil.getTrueLineSegmentIntersection(vectorXZ, vectorXZ2, this.p1, this.p2);
    }

    public double getLength() {
        return VectorXZ.distance(this.p1, this.p2);
    }

    public String toString() {
        return "[" + this.p1 + ", " + this.p2 + "]";
    }
}

