/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;

public class PolygonWithHolesXZ {
    private final SimplePolygonXZ outerPolygon;
    private final List<SimplePolygonXZ> holes;

    public PolygonWithHolesXZ(SimplePolygonXZ simplePolygonXZ, List<SimplePolygonXZ> list) {
        this.outerPolygon = simplePolygonXZ;
        this.holes = list;
    }

    public SimplePolygonXZ getOuter() {
        return this.outerPolygon;
    }

    public List<SimplePolygonXZ> getHoles() {
        return this.holes;
    }

    public List<SimplePolygonXZ> getPolygons() {
        if (this.holes.isEmpty()) {
            return Collections.singletonList(this.outerPolygon);
        }
        ArrayList<SimplePolygonXZ> arrayList = new ArrayList<SimplePolygonXZ>(this.holes.size() + 1);
        arrayList.add(this.outerPolygon);
        arrayList.addAll(this.holes);
        return arrayList;
    }

    public TriangleXZ asTriangleXZ() {
        if (!this.holes.isEmpty()) {
            throw new InvalidGeometryException("polygon has holes, it cannot be used as a triangle");
        }
        return this.outerPolygon.asTriangleXZ();
    }

    public boolean contains(SimplePolygonXZ simplePolygonXZ) {
        if (!this.outerPolygon.contains(simplePolygonXZ)) {
            return false;
        }
        for (SimplePolygonXZ simplePolygonXZ2 : this.holes) {
            if (!simplePolygonXZ2.contains(simplePolygonXZ)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(VectorXZ vectorXZ) {
        if (!this.outerPolygon.contains(vectorXZ)) {
            return false;
        }
        for (SimplePolygonXZ simplePolygonXZ : this.holes) {
            if (!simplePolygonXZ.contains(vectorXZ)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(LineSegmentXZ lineSegmentXZ) {
        if (!this.contains(lineSegmentXZ.p1) || !this.contains(lineSegmentXZ.p2)) {
            return false;
        }
        for (SimplePolygonXZ simplePolygonXZ : this.holes) {
            if (!simplePolygonXZ.intersects(lineSegmentXZ.p1, lineSegmentXZ.p2)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(LineSegmentXZ lineSegmentXZ) {
        for (SimplePolygonXZ simplePolygonXZ : this.holes) {
            if (!simplePolygonXZ.intersects(lineSegmentXZ)) continue;
            return true;
        }
        return this.outerPolygon.intersects(lineSegmentXZ);
    }

    public boolean intersects(SimplePolygonXZ simplePolygonXZ) {
        for (SimplePolygonXZ simplePolygonXZ2 : this.holes) {
            if (!simplePolygonXZ2.intersects(simplePolygonXZ)) continue;
            return true;
        }
        return this.outerPolygon.intersects(simplePolygonXZ);
    }

    public Collection<VectorXZ> intersectionPositions(LineSegmentXZ lineSegmentXZ) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>();
        for (SimplePolygonXZ simplePolygonXZ : this.holes) {
            arrayList.addAll(simplePolygonXZ.intersectionPositions(lineSegmentXZ));
        }
        arrayList.addAll(this.outerPolygon.intersectionPositions(lineSegmentXZ));
        return arrayList;
    }

    public Collection<VectorXZ> intersectionPositions(PolygonWithHolesXZ polygonWithHolesXZ) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>();
        for (SimplePolygonXZ simplePolygonXZ : polygonWithHolesXZ.getPolygons()) {
            for (LineSegmentXZ lineSegmentXZ : simplePolygonXZ.getSegments()) {
                arrayList.addAll(this.intersectionPositions(lineSegmentXZ));
            }
        }
        return arrayList;
    }

    public double getArea() {
        double d = this.outerPolygon.getArea();
        for (SimplePolygonXZ simplePolygonXZ : this.holes) {
            d -= simplePolygonXZ.getArea();
        }
        return d;
    }
}

