/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXYZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class PolygonXYZ {
    private final List<VectorXYZ> vertexLoop;

    public PolygonXYZ(List<VectorXYZ> list) {
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            throw new IllegalArgumentException("first and last vertex must be equal");
        }
        this.vertexLoop = list;
    }

    public List<VectorXYZ> getVertices() {
        return this.vertexLoop.subList(0, this.vertexLoop.size() - 1);
    }

    public List<VectorXYZ> getVertexLoop() {
        return this.vertexLoop;
    }

    public int size() {
        return this.vertexLoop.size() - 1;
    }

    public List<LineSegmentXYZ> getSegments() {
        ArrayList<LineSegmentXYZ> arrayList = new ArrayList<LineSegmentXYZ>(this.vertexLoop.size());
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            arrayList.add(new LineSegmentXYZ(this.vertexLoop.get(n), this.vertexLoop.get(n + 1)));
            ++n;
        }
        return arrayList;
    }

    public PolygonXZ getXZPolygon() {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.vertexLoop.size());
        for (VectorXYZ vectorXYZ : this.vertexLoop) {
            arrayList.add(vectorXYZ.xz());
        }
        return new PolygonXZ(arrayList);
    }

    public SimplePolygonXZ getSimpleXZPolygon() {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.vertexLoop.size());
        for (VectorXYZ vectorXYZ : this.vertexLoop) {
            arrayList.add(vectorXYZ.xz());
        }
        return new SimplePolygonXZ(arrayList);
    }

    public TriangleXYZ asTriangleXYZ() {
        if (this.vertexLoop.size() != 4) {
            throw new InvalidGeometryException("attempted creation of triangle from polygon with vertex loop of size " + this.vertexLoop.size() + ": " + this.vertexLoop);
        }
        return new TriangleXYZ(this.vertexLoop.get(0), this.vertexLoop.get(1), this.vertexLoop.get(2));
    }

    public PolygonXYZ reverse() {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(this.vertexLoop);
        Collections.reverse(arrayList);
        return new PolygonXYZ(arrayList);
    }
}

