/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;

public class PolygonXZ {
    protected final List<VectorXZ> vertexLoop;

    public PolygonXZ(List<VectorXZ> list) {
        PolygonXZ.assertLoopProperty(list);
        this.vertexLoop = list;
    }

    public int size() {
        return this.vertexLoop.size() - 1;
    }

    public List<VectorXZ> getVertices() {
        return this.vertexLoop.subList(0, this.vertexLoop.size() - 1);
    }

    public List<VectorXZ> getVertexLoop() {
        return this.vertexLoop;
    }

    public VectorXZ getVertex(int n) {
        assert (0 <= n && n < this.vertexLoop.size() - 1);
        return this.vertexLoop.get(n);
    }

    public VectorXZ getVertexAfter(int n) {
        assert (0 <= n && n < this.vertexLoop.size() - 1);
        return this.getVertex((n + 1) % this.size());
    }

    public VectorXZ getVertexBefore(int n) {
        assert (0 <= n && n < this.vertexLoop.size() - 1);
        return this.getVertex((n + this.size() - 1) % this.size());
    }

    public List<LineSegmentXZ> getSegments() {
        ArrayList<LineSegmentXZ> arrayList = new ArrayList<LineSegmentXZ>(this.vertexLoop.size());
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            arrayList.add(new LineSegmentXZ(this.vertexLoop.get(n), this.vertexLoop.get(n + 1)));
            ++n;
        }
        return arrayList;
    }

    public LineSegmentXZ getClosestSegment(VectorXZ vectorXZ) {
        LineSegmentXZ lineSegmentXZ = null;
        double d = Double.MAX_VALUE;
        for (LineSegmentXZ lineSegmentXZ2 : this.getSegments()) {
            double d2 = GeometryUtil.distanceFromLineSegment(vectorXZ, lineSegmentXZ2);
            if (!(d2 < d)) continue;
            lineSegmentXZ = lineSegmentXZ2;
            d = d2;
        }
        return lineSegmentXZ;
    }

    public boolean intersects(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            VectorXZ vectorXZ3 = GeometryUtil.getTrueLineSegmentIntersection(vectorXZ, vectorXZ2, this.vertexLoop.get(n), this.vertexLoop.get(n + 1));
            if (vectorXZ3 != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean intersects(LineSegmentXZ lineSegmentXZ) {
        return this.intersects(lineSegmentXZ.p1, lineSegmentXZ.p2);
    }

    public boolean intersects(PolygonXZ polygonXZ) {
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            if (polygonXZ.intersects(this.vertexLoop.get(n), this.vertexLoop.get(n + 1))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Collection<LineSegmentXZ> intersectionSegments(LineSegmentXZ lineSegmentXZ) {
        ArrayList<LineSegmentXZ> arrayList = new ArrayList<LineSegmentXZ>();
        for (LineSegmentXZ lineSegmentXZ2 : this.getSegments()) {
            VectorXZ vectorXZ = GeometryUtil.getTrueLineSegmentIntersection(lineSegmentXZ.p1, lineSegmentXZ.p2, lineSegmentXZ2.p1, lineSegmentXZ2.p2);
            if (vectorXZ == null) continue;
            arrayList.add(lineSegmentXZ2);
        }
        return arrayList;
    }

    public Collection<VectorXZ> intersectionPositions(LineSegmentXZ lineSegmentXZ) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>();
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            VectorXZ vectorXZ = GeometryUtil.getTrueLineSegmentIntersection(lineSegmentXZ.p1, lineSegmentXZ.p2, this.vertexLoop.get(n), this.vertexLoop.get(n + 1));
            if (vectorXZ != null) {
                arrayList.add(vectorXZ);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean isSelfIntersecting() {
        return PolygonXZ.isSelfIntersecting(this.vertexLoop);
    }

    public static boolean isSelfIntersecting(List<VectorXZ> list) {
        int n = 0;
        while (n + 1 < list.size()) {
            int n2 = n + 1;
            while (n2 + 1 < list.size()) {
                VectorXZ vectorXZ = GeometryUtil.getTrueLineSegmentIntersection(list.get(n), list.get(n + 1), list.get(n2), list.get(n2 + 1));
                if (vectorXZ != null) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public boolean isSimple() {
        try {
            this.asSimplePolygon();
            return true;
        }
        catch (InvalidGeometryException invalidGeometryException) {
            return false;
        }
    }

    public SimplePolygonXZ asSimplePolygon() {
        return new SimplePolygonXZ(this.vertexLoop);
    }

    public TriangleXZ asTriangleXZ() {
        if (this.vertexLoop.size() != 4) {
            throw new InvalidGeometryException("attempted creation of triangle from polygon with vertex loop of size " + this.vertexLoop.size() + ": " + this.vertexLoop);
        }
        return new TriangleXZ(this.vertexLoop.get(0), this.vertexLoop.get(1), this.vertexLoop.get(2));
    }

    public PolygonXYZ xyz(double d) {
        return new PolygonXYZ(VectorXZ.listXYZ(this.vertexLoop, d));
    }

    public PolygonXZ reverse() {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.vertexLoop);
        Collections.reverse(arrayList);
        return new PolygonXZ(arrayList);
    }

    public VectorXZ getCenter() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.vertexLoop.size() - 1;
        for (VectorXZ vectorXZ : this.getVertices()) {
            d += vectorXZ.x / (double)n;
            d2 += vectorXZ.z / (double)n;
        }
        return new VectorXZ(d, d2);
    }

    public double getOutlineLength() {
        double d = 0.0;
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            d += VectorXZ.distance(this.vertexLoop.get(n), this.vertexLoop.get(n + 1));
            ++n;
        }
        return d;
    }

    public boolean isEquivalentTo(PolygonXZ polygonXZ) {
        if (this.vertexLoop.size() != polygonXZ.vertexLoop.size()) {
            return false;
        }
        List<VectorXZ> list = this.getVertices();
        List<VectorXZ> list2 = polygonXZ.getVertices();
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = true;
            for (int j = 0; j < list.size(); ++j) {
                int n = (j + i) % list.size();
                if (list2.get(j).equals(list.get(n))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    protected static void assertLoopProperty(List<VectorXZ> list) {
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            throw new IllegalArgumentException("first and last vertex must be equal\nPolygon vertices: " + list);
        }
    }

    public String toString() {
        return this.vertexLoop.toString();
    }
}

